/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

public final class Cryptor {
    private String m_Key;
    private int m_LFSR_A = 324508639;
    private int m_LFSR_B = 610839776;
    private int m_LFSR_C = -38177487;
    private int m_Mask_A = -2147483550;
    private int m_Mask_B = 0x40000020;
    private int m_Mask_C = 0x10000002;
    private int m_Rot0_A = Integer.MAX_VALUE;
    private int m_Rot0_B = 0x3FFFFFFF;
    private int m_Rot0_C = 0xFFFFFFF;
    private int m_Rot1_A = Integer.MIN_VALUE;
    private int m_Rot1_B = -1073741824;
    private int m_Rot1_C = -268435456;

    public byte[] transformString(String key, byte[] inBytes) {
        this.setKey(key);
        int length = inBytes.length;
        byte[] outBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            outBytes[i] = this.transformByte(inBytes[i]);
        }
        return outBytes;
    }

    private byte transformByte(byte Target) {
        int Counter = 0;
        byte Crypto = 0;
        int Out_B = this.m_LFSR_B & 1;
        int Out_C = this.m_LFSR_C & 1;
        for (Counter = 0; Counter < 8; ++Counter) {
            if (0 != (this.m_LFSR_A & 1)) {
                this.m_LFSR_A = this.m_LFSR_A ^ this.m_Mask_A >>> 1 | this.m_Rot1_A;
                if (0 != (this.m_LFSR_B & 1)) {
                    this.m_LFSR_B = this.m_LFSR_B ^ this.m_Mask_B >>> 1 | this.m_Rot1_B;
                    Out_B = 1;
                } else {
                    this.m_LFSR_B = this.m_LFSR_B >>> 1 & this.m_Rot0_B;
                    Out_B = 0;
                }
            } else {
                this.m_LFSR_A = this.m_LFSR_A >>> 1 & this.m_Rot0_A;
                if (0 != (this.m_LFSR_C & 1)) {
                    this.m_LFSR_C = this.m_LFSR_C ^ this.m_Mask_C >>> 1 | this.m_Rot1_C;
                    Out_C = 1;
                } else {
                    this.m_LFSR_C = this.m_LFSR_C >>> 1 & this.m_Rot0_C;
                    Out_C = 0;
                }
            }
            Crypto = (byte)(Crypto << 1 | Out_B ^ Out_C);
        }
        Target = (byte)(Target ^ Crypto);
        return Target;
    }

    private void setKey(String Key2) {
        int Index = 0;
        this.m_Key = Key2;
        if (0 == Key2.length()) {
            Key2 = "Default Seed";
        }
        char[] Seed = new char[Key2.length() < 12 ? 12 : Key2.length()];
        this.m_Key.getChars(0, this.m_Key.length(), Seed, 0);
        int originalLength = this.m_Key.length();
        Index = 0;
        while (originalLength + Index < 12) {
            Seed[originalLength + Index] = Seed[Index];
            ++Index;
        }
        for (Index = 0; Index < 4; ++Index) {
            this.m_LFSR_A <<= 8;
            this.m_LFSR_A |= Seed[Index + 4];
            this.m_LFSR_B <<= 8;
            this.m_LFSR_B |= Seed[Index + 4];
            this.m_LFSR_C <<= 8;
            this.m_LFSR_C |= Seed[Index + 4];
        }
        if (0 == this.m_LFSR_A) {
            this.m_LFSR_A = 324508639;
        }
        if (0 == this.m_LFSR_B) {
            this.m_LFSR_B = 610839776;
        }
        if (0 == this.m_LFSR_C) {
            this.m_LFSR_C = -38177487;
        }
    }
}

