/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class OleDateTime
extends Date {
    protected static long daylight = 3600000L;
    protected static final double daysSince1899 = 25569.0;
    protected static final double millisPerDay = 8.64E7;

    public OleDateTime(Date d) {
        super(d.getTime());
    }

    public OleDateTime(long l) {
        super(l);
    }

    public OleDateTime(int year, int month, int day, int hour, int minute, int second) {
        super(year, month, day, hour, minute, second);
    }

    public OleDateTime(double date) {
        this.setDate(date);
    }

    public Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public void setDate(double dtSrc) {
        Calendar c = this.getCalendar();
        c.clear();
        long days = (long)Math.floor(dtSrc);
        long partialDay = Math.round((dtSrc - (double)days) * 8.64E7);
        c.set(1899, 11, 30, 0, 0, 0);
        c.add(14, (int)partialDay);
        c.add(6, (int)days);
        this.setTime(c.getTimeInMillis());
    }

    public double toDouble() {
        TimeZone tz = this.getTimeZone();
        long millis = this.getTime();
        if (tz.inDaylightTime(new Date(millis -= millis % 1000L))) {
            millis += daylight;
        }
        return 25569.0 + (double)(millis + (long)tz.getRawOffset()) / 8.64E7;
    }

    @Override
    public String toString() {
        return OleDateTime.toString(this);
    }

    @Override
    public int getMonth() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(2);
    }

    @Override
    public int getDate() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(5);
    }

    @Override
    public int getHours() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(11);
    }

    @Override
    public int getMinutes() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(12);
    }

    @Override
    public int getSeconds() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(13);
    }

    @Override
    public int getDay() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(7);
    }

    @Override
    public int getYear() {
        Calendar c = this.getCalendar();
        c.clear();
        c.setTime(this);
        return c.get(1) - 1900;
    }

    public static String toString(Date dateObj) {
        int second;
        int minute;
        int hour;
        int year;
        int date;
        String yearPad = "";
        String monthPad = "";
        String datePad = "";
        String hourPad = "";
        String minutePad = "";
        String secondPad = "";
        int month = 1 + dateObj.getMonth();
        if (month < 10) {
            monthPad = "0";
        }
        if ((date = dateObj.getDate()) < 10) {
            datePad = "0";
        }
        if ((year = OleDateTime.getCfYear(dateObj)) > 99 && year < 1000) {
            yearPad = "0";
        }
        if ((hour = dateObj.getHours()) < 10) {
            hourPad = "0";
        }
        if ((minute = dateObj.getMinutes()) < 10) {
            minutePad = "0";
        }
        if ((second = dateObj.getSeconds()) < 10) {
            secondPad = "0";
        }
        StringBuilder buff = new StringBuilder();
        buff.append("{ts '").append(yearPad).append(year).append('-').append(monthPad).append(month).append('-');
        buff.append(datePad).append(date).append(' ').append(hourPad).append(hour).append(':');
        buff.append(minutePad).append(minute).append(':').append(secondPad).append(second).append("'}");
        return buff.toString();
    }

    int getCfYear() {
        return OleDateTime.getCfYear(this);
    }

    static int getCfYear(Date dateObj) {
        int year = dateObj.getYear() + 1900;
        if (year >= 0 && year <= 29) {
            year += 2000;
        } else if (year >= 30 && year <= 99) {
            year += 1900;
        }
        return year;
    }

    protected void removeTime() {
        Calendar cal = this.getCalendar();
        cal.setTime(this);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.setTime(cal.getTimeInMillis());
    }

    protected void removeDate() {
        Calendar cal = this.getCalendar();
        cal.setTime(this);
        cal.set(1, 1899);
        cal.set(2, 11);
        cal.set(5, 30);
        this.setTime(cal.getTimeInMillis());
    }
}

