/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ScheduleTagData
extends TreeMap {
    public static String URL = "url";
    public static String EVENT_HANDLER = "eventhandler";
    public static String INTERVAL = "interval";
    private static String START_TIME = "start_time";
    List<String> restrictedListFOrProbe = Arrays.asList("http_port", "resolve_url", "proxy_server", "remainingCount", "onexception", "http_proxy_port", "proxy_password");

    public ScheduleTagData() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public static ScheduleTagData defaultMap() {
        ScheduleTagData scheduleTagData = new ScheduleTagData();
        scheduleTagData.put("path", "");
        scheduleTagData.put("start_time", "");
        scheduleTagData.put("start_date", LocalDate.now().format(DateTimeFormatter.ofPattern("MM/dd/yyyy")));
        scheduleTagData.put("overwrite", true);
        scheduleTagData.put("mode", "");
        scheduleTagData.put("appname", "");
        scheduleTagData.put("repeat", "-1");
        scheduleTagData.put("mode", "server");
        scheduleTagData.put("http_port", "8500");
        scheduleTagData.put("priority", "5");
        scheduleTagData.put("group", "default");
        scheduleTagData.put("resolveurl", false);
        scheduleTagData.put("status", "Running");
        scheduleTagData.put("chained", false);
        scheduleTagData.put("proxy_server", "");
        scheduleTagData.put("username", "");
        scheduleTagData.put("file", "");
        scheduleTagData.put(INTERVAL, null);
        scheduleTagData.put("eventhandler", "");
        scheduleTagData.put("remainingCount", null);
        scheduleTagData.put("misfire", "");
        scheduleTagData.put("retrycount", "3");
        scheduleTagData.put("onexception", "");
        scheduleTagData.put("publish", false);
        scheduleTagData.put("clustered", false);
        scheduleTagData.put("eventhandlerrp", null);
        scheduleTagData.put("http_proxy_port", "80");
        scheduleTagData.put("crontime", "");
        scheduleTagData.put("password", "");
        scheduleTagData.put("oncomplete", "");
        scheduleTagData.put("proxy_password", "");
        scheduleTagData.put("exclude", "");
        return scheduleTagData;
    }

    public boolean validateData() {
        boolean isValid = true;
        boolean isUrlPresent = false;
        boolean isEventHandlerPresent = false;
        boolean isProbe = ((String)this.get("task")).toUpperCase().startsWith("CFPROBE___");
        Iterator<Object> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            String urlString;
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals(INTERVAL)) {
                if (value == null || StringUtils.isBlank((CharSequence)String.valueOf(value))) {
                    this.put("chained", true);
                } else {
                    String interval = String.valueOf(value);
                    if (ScheduleTagData.isValidInterval(interval)) {
                        this.put(INTERVAL, Interval.getInterval(interval).val());
                    }
                    if (!(isValid &= NumberUtils.isNumber((String)interval) || ScheduleTagData.isValidInterval(interval) || StringUtils.isNotBlank((CharSequence)((String)this.get("crontime"))))) {
                        MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", INTERVAL));
                        throw new CFSetupException(Messages.getString("invalidAttributeVal", INTERVAL));
                    }
                    if (StringUtils.isBlank((CharSequence)((String)this.get("crontime"))) && !(isValid &= !ScheduleTagData.isValidInterval(interval) || !StringUtils.isBlank((CharSequence)((String)this.get(START_TIME))))) {
                        MessageHandler.getInstance().showError(Messages.getString("dependentRequiremnet", START_TIME, INTERVAL, interval));
                        throw new CFSetupException(Messages.getString("dependentRequiremnet", START_TIME, INTERVAL, interval));
                    }
                }
            }
            if (key.equals(URL) && !isProbe && (isUrlPresent = StringUtils.isNotBlank((CharSequence)(urlString = (String)value)))) {
                try {
                    URL url = new URL(urlString);
                    int port = url.getPort();
                    urlString = urlString.replace(":" + port, "");
                    this.put(URL, urlString);
                    if (port != -1) {
                        this.put("http_port", String.valueOf(port));
                    }
                }
                catch (MalformedURLException e) {
                    MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", URL));
                    throw new CFSetupException(Messages.getString("invalidAttributeVal", URL));
                }
            }
            if (!key.equals(EVENT_HANDLER)) continue;
            String eh = (String)value;
            isEventHandlerPresent = StringUtils.isNotBlank((CharSequence)eh);
        }
        if (!(isUrlPresent || isEventHandlerPresent || isProbe)) {
            MessageHandler.getInstance().showError(Messages.getString("urlEventHandlerMissing"));
            throw new CFSetupException(Messages.getString("urlEventHandlerMissing"));
        }
        if (isProbe) {
            this.put("overwrite", "true");
            this.put("chained", "false");
            this.put("clustered", "false");
            this.put("crontime", null);
            this.put("oncomplete", null);
            this.put("onexception", null);
            this.put("exclude", null);
            if (!isEventHandlerPresent) {
                this.put("eventhandler", null);
            }
            if (StringUtils.isBlank((CharSequence)((String)this.get("end_time")))) {
                this.remove("end_time");
            }
            for (String k : this.restrictedListFOrProbe) {
                this.remove(k);
            }
        }
        return isValid;
    }

    public static boolean isValidInterval(String val) {
        return Arrays.stream(Interval.values()).anyMatch(v -> v.val.equalsIgnoreCase(val));
    }

    private static enum Interval {
        DAILY("Daily"),
        ONCE("ONCE"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        String val;

        private Interval(String val) {
            this.val = val;
        }

        public static Interval getInterval(String val) {
            Interval res = null;
            for (Interval interval : Interval.values()) {
                if (!interval.name().equalsIgnoreCase(val)) continue;
                res = interval;
            }
            return res;
        }

        public String val() {
            return this.val;
        }
    }
}

