/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.MD5;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final String DEFAULT_ENC_ALGO = "AES/CBC/PKCS5Padding";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA_256 = "SHA-256";
    private static final int USER_SALT_SIZE = 16;
    private static Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
    private static Random secRandom = new SecureRandom();

    public static boolean isPolicyFilesInstalled() {
        try {
            int keyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (keyLength == Integer.MAX_VALUE) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public static String hash(Object string, String algorithm, String encoding, String salt) throws IOException {
        return SecurityUtils.hash(string, algorithm, encoding, salt, 0);
    }

    public static String hash(Object string, String algorithm, String encoding, String salt, int numIter) throws IOException {
        MessageDigest digest;
        if (string == null) {
            return null;
        }
        if (algorithm == null || algorithm.equalsIgnoreCase(DEFAULT_ENC_ALGO)) {
            MD5 md5 = null;
            md5 = string instanceof byte[] ? new MD5((byte[])string) : new MD5(Cast._String(string));
            md5.getDigest();
            return md5.getStringDigest();
        }
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        byte[] input = null;
        input = string instanceof byte[] ? (byte[])string : Cast._String(string).getBytes(encoding);
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new InvalidAlgoException(algorithm);
        }
        digest.reset();
        if (salt != null && salt.length() > 0) {
            digest.update(salt.getBytes(encoding));
            input = digest.digest(input);
        } else {
            digest.update(input);
            input = digest.digest();
        }
        if (numIter > 0) {
            for (int i = 0; i < numIter; ++i) {
                digest.reset();
                input = digest.digest(input);
            }
        }
        return MD5.stringify(input);
    }

    public static String getNewSalt() {
        return MD5.stringify(SecurityUtils.generateRandom(16));
    }

    public static byte[] generateRandom(int numBytes) {
        if (numBytes <= 0) {
            numBytes = 20;
        }
        byte[] salt = new byte[numBytes];
        secRandom.nextBytes(salt);
        return salt;
    }

    public static class InvalidAlgoException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String algorithm;
        public String function;

        InvalidAlgoException() {
            this.algorithm = "AES/CBC/PKCS5Padding or null";
        }

        InvalidAlgoException(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

