/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.ConfigMapListener;
import coldfusion.Service;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.server.Formatter;
import coldfusion.util.IteratorEnumeration;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ConfigMap
extends TreeMap {
    private Service service;
    private String valuename;
    private String name;
    private String[] keys;
    private String[] formats;
    private String[] types;
    private boolean changed;
    private ConfigMapListener listener;

    public ConfigMap() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public ConfigMap(Map map) {
        super(String.CASE_INSENSITIVE_ORDER);
        this.putAll(map);
    }

    public ConfigMap(Service service, String name) {
        this.init(service, name);
    }

    public synchronized void init(Service service, String name) {
        this.name = name;
        this.service = service;
        Map resourceBundle = service.getResourceBundle();
        try {
            this.valuename = (String)resourceBundle.get(name + ".value");
        }
        catch (MissingResourceException ex) {
            this.valuename = null;
        }
        this.keys = this.tokenize((String)resourceBundle.get(name + ".keys"));
        this.formats = this.tokenize((String)resourceBundle.get(name + ".formats"));
        this.types = this.tokenize((String)resourceBundle.get(name + ".types"));
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(ConfigMap map, Object key, Object value) {
        this.changed = true;
        if (this.listener != null) {
            this.listener.mapModified(this, key, value);
        }
    }

    public void setChanged(ConfigMap map, Object key) {
        this.changed = true;
        if (this.listener != null) {
            this.listener.mapModified(this, key);
        }
    }

    public void setChanged() {
        this.changed = true;
        if (this.listener != null) {
            this.listener.mapModified();
        }
    }

    public void setUnchanged() {
        this.changed = false;
    }

    public void setConfigMapListener(ConfigMapListener l) {
        this.listener = l;
    }

    public ConfigMapListener getConfigMapListener() {
        return this.listener;
    }

    private boolean isAllowedKey(String k) {
        if (this.keys == null) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equalsIgnoreCase(k)) continue;
            return true;
        }
        return false;
    }

    private String getFormatter(String k) {
        if (this.formats == null) {
            return null;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.keys[i].equalsIgnoreCase(k)) continue;
                return this.formats[i];
            }
        } else if (this.formats.length == 1) {
            return this.formats[0];
        }
        return null;
    }

    private boolean isAllowedValueType(String k, Object v) {
        block8: {
            Class<?> type;
            block7: {
                if (this.types == null) {
                    return true;
                }
                type = v.getClass();
                if (this.keys != null) break block7;
                for (int i = 0; i < this.types.length; ++i) {
                    try {
                        if (!Class.forName(this.types[i]).isAssignableFrom(type)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break block8;
            }
            if (this.types == null) break block8;
            for (int i = 0; i < this.types.length && this.keys.length == this.types.length; ++i) {
                try {
                    if (!this.keys[i].equalsIgnoreCase(k) || !Class.forName(this.types[i]).isAssignableFrom(type)) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private String[] tokenize(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(str, ",");
        String[] array = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            array[i] = t.nextToken().intern();
            ++i;
        }
        return array;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof String && this.isAllowedKey((String)key)) {
            Formatter f = null;
            Object old = null;
            try {
                f = (Formatter)Class.forName(this.getFormatter((String)key)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                try {
                    value = f.format(value, this.service, this.valuename);
                }
                catch (IllegalArgumentException ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException((key != null ? key.toString() : "") + "=" + (value != null ? value.toString() : ""));
                }
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception exception) {
                // empty catch block
            }
            old = super.put(key, value);
            if (!(old == value || old != null && old.equals(value))) {
                this.setChanged(this, key, value);
            }
            return old;
        }
        throw new IllegalArgumentException((key != null ? key.toString() : "") + "=" + (value != null ? value.toString() : ""));
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.setChanged();
    }

    @Override
    public synchronized void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.setChanged();
    }

    @Override
    public Object remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.setChanged(this, key);
        } else {
            this.setUnchanged();
        }
        return value;
    }

    public static ConfigMap toConfigMap(Object obj) {
        if (obj instanceof ConfigMap) {
            return (ConfigMap)obj;
        }
        if (obj instanceof Map) {
            ConfigMap m = new ConfigMap();
            m.putAll((Map)obj);
            return m;
        }
        return null;
    }

    public Enumeration elements() {
        return new IteratorEnumeration(this.values().iterator());
    }

    public synchronized Map duplicate(IdentityHashMap refCache) throws IllegalAccessException {
        if (refCache == null) {
            refCache = new IdentityHashMap<ConfigMap, ConfigMap>();
        }
        ConfigMap result = new ConfigMap();
        refCache.put(this, result);
        if (this.service != null && this.name != null) {
            result.init(this.service, this.name);
        }
        for (Map.Entry e : this.entrySet()) {
            String key = (String)e.getKey();
            Object origObject = e.getValue();
            result.put(key, ObjectDuplicator.duplicate(origObject, refCache));
        }
        return result;
    }
}

