/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import com.adobe.cfsetup.KeytoolUtils;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.File;
import java.io.IOException;

public class SslCertificateManager {
    private File configFile;
    private static final String RSA = "RSA";
    private ServerConfigParser serverConfigParser;

    public SslCertificateManager(String configFileName) {
        this.configFile = new File(configFileName);
        this.serverConfigParser = new ServerConfigParser(configFileName);
    }

    public boolean generateKeyAndCertificate(String dname, String keystoreFileName, String password, boolean setInServerXml) {
        String parentDir = this.configFile.getParent();
        String selfSignedCertPath = parentDir + File.separator + keystoreFileName;
        KeytoolUtils keytoolUtils = new KeytoolUtils(parentDir);
        try {
            boolean retVal = keytoolUtils.generateKeyAndCertificate(dname, keystoreFileName, password);
            if (retVal && setInServerXml) {
                this.updateSslConfig(selfSignedCertPath, password, RSA, setInServerXml, true);
            }
            return retVal;
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(Messages.getString("ssl.exceptionForCreatingConfigFiles", e.getMessage()));
            return false;
        }
    }

    public void updateSslConfig(String certificatePath, String certificatePassword, String certificateAlgorithm, boolean enableHttps, boolean enableHttp) {
        String serverXmlPath = this.configFile.getAbsolutePath();
        try {
            this.serverConfigParser.updateServerSslFile(serverXmlPath, certificatePath, certificatePassword, certificateAlgorithm, enableHttps, enableHttp);
        }
        catch (IOException e) {
            MessageHandler.getInstance().showError(Messages.getString("ssl.updateSSlconfigFail", e.getMessage()));
            e.printStackTrace();
        }
    }
}

