/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.centralConfigServer;

import coldfusion.server.ServiceRuntimeException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.constants.Messages;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class CentralConfigServerUtil {
    private boolean isCCSEnabled = false;
    private String ccsServerIP = "localhost";
    private int ccsServerPort = 7071;
    private String ccsSecretKey = "";
    private String hostname = "localhost";
    private String hostport = "hostport";
    private String context = "context";
    private boolean isCCSRunning = false;
    private boolean ccsCheckDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCCSRunning() {
        String url = this.getHealthURL();
        url = this.appendMetadata(url);
        HttpGet get = new HttpGet(url);
        String content = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (content.equals("OK")) {
                this.isCCSRunning = true;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.ccsCheckDone = true;
        }
        return false;
    }

    private String appendMetadata(String url) {
        url = this.appendHostnamePort(url);
        url = this.appendSecretKey(url, true);
        return url;
    }

    private String appendHostnamePort(String url) {
        url = (String)url + "?hostname=" + this.hostname + "&hostport=" + this.hostport + "&context=" + this.context;
        return url;
    }

    private String appendSecretKey(String url, boolean notFirstQueryParam) {
        url = notFirstQueryParam ? (String)url + "&secretkey=" + this.ccsSecretKey : (String)url + "?secretkey=" + this.ccsSecretKey;
        return url;
    }

    private String getHealthURL() {
        return "http://" + this.ccsServerIP + ":" + this.ccsServerPort + "/health/";
    }

    private void initCCSSettings(File file) {
        String ccsinfo = file.getAbsolutePath() + File.separator + "lib" + File.separator + "ccs" + File.separator + "ccs.properties";
        Properties _props = new Properties();
        try {
            DataInputStream ds = new DataInputStream(new FileInputStream(ccsinfo));
            _props.load(ds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String ccsEnabledKey = "enabled";
        String ccsPortKey = "port";
        String ccsIPKey = "server";
        String secretKeyKey = "ccssecretkey";
        String hostnameyKey = "hostname";
        String hostportKey = "hostport";
        String contextKey = "context";
        if (_props.getProperty(ccsEnabledKey) != null) {
            this.isCCSEnabled = Boolean.valueOf(_props.getProperty(ccsEnabledKey));
        }
        if (_props.getProperty(ccsIPKey) != null) {
            this.ccsServerIP = _props.getProperty(ccsIPKey);
        }
        if (_props.getProperty(ccsPortKey) != null) {
            this.ccsServerPort = Integer.valueOf(_props.getProperty(ccsPortKey));
        }
        if (_props.getProperty(secretKeyKey) != null) {
            this.ccsSecretKey = _props.getProperty(secretKeyKey);
        }
        if (_props.getProperty(hostnameyKey) != null) {
            this.hostname = _props.getProperty(hostnameyKey);
        }
        if (_props.getProperty(hostportKey) != null) {
            this.hostport = _props.getProperty(hostportKey);
        }
        if (_props.getProperty(contextKey) != null) {
            this.context = _props.getProperty(contextKey);
        }
    }

    public void isCCSEnabledButNotRunning(File file) {
        if (null == file) {
            return;
        }
        this.initCCSSettings(file);
        boolean isCCSEnbledButNotRunning = false;
        if (this.isCCSEnabled) {
            boolean isCCSRunning = this.isCCSAvailaible();
            boolean bl = isCCSEnbledButNotRunning = !isCCSRunning;
        }
        if (isCCSEnbledButNotRunning) {
            String errMsg = Messages.getString("CCS.ccsEnabledButNotRunning");
            MessageHandler.getInstance().showError(errMsg);
            throw new ServiceRuntimeException(errMsg);
        }
    }

    public boolean isCCSAvailaible() {
        if (!this.isCCSEnabled) {
            return false;
        }
        if (this.isCCSRunning) {
            return true;
        }
        if (this.ccsCheckDone) {
            return false;
        }
        this.isCCSRunning = this.isCCSRunning();
        return this.isCCSRunning;
    }
}

