/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ExpressionException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class IniUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _filename;
    private ArrayList<OrderedSection> _sections = new ArrayList();
    private Hashtable<String, OrderedSection> _sectionsByName = new Hashtable();
    private Hashtable<String, String> _comment_blocks = new Hashtable();
    private static final String WHITESPACE = " \t\n\r\f";
    private String _sep = System.getProperty("line.separator");
    private int _sep_len = this._sep.length();
    private static Hashtable<String, FileLock> _openFiles = new Hashtable();
    private String encoding = null;

    public IniUtils(String filename) throws IniFileException, InvalidIniSectionNameException, InvalidIniPropertyException {
        this._filename = filename;
    }

    public IniUtils(String filename, String encoding) {
        this(filename);
    }

    public String getProfileString(String section, String property) throws InvalidIniSectionNameException, InvalidIniPropertyException {
        this.init(false);
        OrderedSection sect = this._sectionsByName.get(section.toLowerCase());
        if (sect == null) {
            throw new InvalidIniSectionNameException(this._filename, section);
        }
        return sect.getValue(property);
    }

    private void init(boolean createFlag) {
        File ini;
        try {
            ini = new File(this._filename);
            File parent = ini.getParentFile();
            if (parent != null && !parent.isDirectory()) {
                throw new InvalidIniPathException(this._filename);
            }
            if (!ini.exists() && createFlag) {
                ini.createNewFile();
            }
        }
        catch (FileNotFoundException ex) {
            throw new InvalidIniPathException(this._filename);
        }
        catch (IOException e) {
            throw new IniFileException(this._filename, e);
        }
        this.load(ini);
    }

    private void load(File file) {
        BufferedReader reader = null;
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            InputStreamReader streamReader = new InputStreamReader(stream);
            reader = new BufferedReader(streamReader);
            this.encoding = streamReader.getEncoding();
            String line = null;
            StringBuffer buffer = new StringBuffer(100);
            int comment_length = 0;
            String sectionName = null;
            while ((line = reader.readLine()) != null) {
                String comment = null;
                int len = line.length();
                int start = 0;
                int end = line.trim().length() - 1;
                if (!this.isStartOfSection(line)) {
                    buffer.append(line + this._sep);
                    comment_length += len + this._sep_len;
                    continue;
                }
                if (comment_length != 0) {
                    buffer.setLength(comment_length);
                    comment = buffer.toString();
                }
                if ((sectionName = line.substring(start + 1, end)) == null || sectionName.length() == 0) {
                    throw new InvalidIniSectionNameException(this._filename, sectionName);
                }
                if (comment_length != 0 && sectionName != null) {
                    this._comment_blocks.put(sectionName.toLowerCase(), comment);
                    comment = null;
                    comment_length = 0;
                }
                buffer.setLength(0);
                String lineAfterSection = this.loadSection(sectionName, reader);
                while (this.isStartOfSection(lineAfterSection)) {
                    int o = lineAfterSection.indexOf(91) + 1;
                    int c = lineAfterSection.indexOf(93);
                    sectionName = lineAfterSection.substring(o, c);
                    lineAfterSection = this.loadSection(sectionName, reader);
                }
                if (lineAfterSection != null) {
                    buffer.append(lineAfterSection + this._sep);
                    comment_length += lineAfterSection.length() + this._sep_len;
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException ex) {
            throw new InvalidIniPathException(this._filename);
        }
        catch (IOException e) {
            throw new IniFileException(this._filename, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String loadSection(String sectionName, BufferedReader reader) throws IOException {
        String line = null;
        StringBuffer sectionBuf = new StringBuffer();
        while ((line = reader.readLine()) != null && !this.isEndOfSection(line)) {
            sectionBuf.append(line + this._sep);
        }
        StringReader sectionReader = new StringReader(sectionBuf.toString());
        OrderedSection section = new OrderedSection(sectionName, sectionReader);
        if (this._sectionsByName.get(sectionName.toLowerCase()) == null) {
            this._sections.add(section);
            this._sectionsByName.put(sectionName.toLowerCase(), section);
        }
        return line;
    }

    private boolean isCommentLine(String line) {
        if (line == null) {
            return true;
        }
        String cleanLine = line.trim();
        return cleanLine.startsWith(";") || cleanLine.startsWith("#") && cleanLine.indexOf("=") == -1;
    }

    private boolean isStartOfSection(String line) {
        int start;
        if (line == null || line.trim().length() == 0) {
            return false;
        }
        for (start = 0; start < line.length() && WHITESPACE.indexOf(line.charAt(start)) != -1; ++start) {
        }
        int end = line.trim().length() - 1;
        if (this.isCommentLine(line) || WHITESPACE.indexOf(line.charAt(start)) != -1) {
            return false;
        }
        if (line.charAt(start) == '[' && line.charAt(end) == ']') {
            String sectionName = line.substring(start + 1, end);
            if (sectionName == null || sectionName.length() == 0) {
                throw new InvalidIniSectionNameException(this._filename, sectionName);
            }
            return true;
        }
        return false;
    }

    private boolean isEndOfSection(String line) {
        if (this.isStartOfSection(line)) {
            return true;
        }
        return line == null;
    }

    private class OrderedSection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _sectionName = null;
        private static final String KEY_VALUE_DELIM = "=";
        protected ArrayList<String> _cleanKeys = new ArrayList();
        private Hashtable<String, String> _cleanKeyToOrigKey = new Hashtable();
        private Hashtable<String, String> _cleanKeyToValue = new Hashtable();
        private Hashtable<String, String> _comment_blocks = new Hashtable();
        private String _closingComment = null;
        private int _closingCommentIndex = 0;

        public OrderedSection(String sectionName) throws IOException {
            this._sectionName = sectionName;
        }

        public OrderedSection(String sectionName, Reader br) throws IOException {
            this._sectionName = sectionName;
            this.load(new BufferedReader(br));
        }

        public String getValue(String property) throws InvalidIniPropertyException {
            String cleanKey = property.toLowerCase().trim();
            if (this._cleanKeyToValue.containsKey(cleanKey)) {
                return this._cleanKeyToValue.get(cleanKey);
            }
            throw new InvalidIniPropertyException(IniUtils.this._filename, this._sectionName, property);
        }

        public void setValue(String property, String val) {
            String cleanKey = property.toLowerCase().trim();
            if (!this._cleanKeyToValue.containsKey(cleanKey)) {
                this._cleanKeys.add(cleanKey);
                this._cleanKeyToOrigKey.put(cleanKey, property);
            }
            this._cleanKeyToValue.put(cleanKey, val);
        }

        public String getSectionName() {
            return this._sectionName;
        }

        public void write(PrintWriter out) {
            out.println("[" + this._sectionName + "]");
            int count = 0;
            for (String cleanKey : this._cleanKeys) {
                String value = this._cleanKeyToValue.get(cleanKey);
                String comment = this._comment_blocks.get(cleanKey);
                if (comment != null) {
                    out.print(comment);
                }
                out.println(this._cleanKeyToOrigKey.get(cleanKey) + KEY_VALUE_DELIM + value);
                if (count == this._closingCommentIndex && this._closingComment != null) {
                    out.print(this._closingComment);
                }
                ++count;
            }
            out.flush();
        }

        private void load(BufferedReader br) throws IOException {
            String line;
            StringBuffer buffer = new StringBuffer(100);
            int comment_length = 0;
            while ((line = br.readLine()) != null) {
                String comment = null;
                int len = line.length();
                if (!this.isProperty(line)) {
                    buffer.append(line + IniUtils.this._sep);
                    comment_length += len + IniUtils.this._sep_len;
                    continue;
                }
                if (comment_length != 0) {
                    buffer.setLength(comment_length);
                    comment = buffer.toString();
                }
                this.handleProperty(comment, line);
                buffer.setLength(0);
                comment = null;
                comment_length = 0;
            }
            if (comment_length != 0) {
                buffer.setLength(comment_length);
                this._closingComment = buffer.toString();
                this._closingCommentIndex = this._cleanKeys.size() - 1;
            }
        }

        private boolean isProperty(String line) {
            int start;
            if (line == null || line.trim().length() == 0) {
                return false;
            }
            for (start = 0; start < line.length() && IniUtils.WHITESPACE.indexOf(line.charAt(start)) != -1; ++start) {
            }
            if (IniUtils.this.isCommentLine(line) || IniUtils.WHITESPACE.indexOf(line.charAt(start)) != -1) {
                return false;
            }
            int delimIdx = line.indexOf(KEY_VALUE_DELIM);
            return delimIdx > 0;
        }

        private void handleProperty(String comment, String property) {
            String dirtyKey = null;
            String value = null;
            String cleanKey = null;
            int delimIdx = property.indexOf(KEY_VALUE_DELIM);
            if (delimIdx <= 0) {
                throw new InvalidIniPropertyException(IniUtils.this._filename, this._sectionName, property);
            }
            dirtyKey = property.substring(0, delimIdx);
            value = property.substring(delimIdx + 1);
            cleanKey = dirtyKey.toLowerCase().trim();
            if (this._cleanKeyToOrigKey.get(cleanKey) == null) {
                this._cleanKeys.add(cleanKey);
                this._cleanKeyToOrigKey.put(cleanKey, dirtyKey);
                this._cleanKeyToValue.put(cleanKey, value);
                if (comment != null) {
                    this._comment_blocks.put(cleanKey, comment);
                }
            }
        }
    }

    public static class InvalidIniSectionNameException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        private String _sectionName;
        private String _filename;

        public InvalidIniSectionNameException(String filename, String sectionName) {
            this._filename = filename;
            this._sectionName = sectionName;
        }

        public String getSectionName() {
            return this._sectionName;
        }

        public String getFilename() {
            return this._filename;
        }
    }

    public static class InvalidIniPathException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        private String _filename;

        public InvalidIniPathException(String filename) {
            this._filename = filename;
        }

        public String getFilename() {
            return this._filename;
        }
    }

    public static class IniFileException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String _filename;

        public IniFileException(String filename, Throwable th) {
            super(th);
            this._filename = filename;
        }

        public String getFilename() {
            return this._filename;
        }
    }

    private static class FileLock {
        private int _count = 0;

        private FileLock() {
        }

        public void increment() {
            ++this._count;
        }

        public void decrement() {
            --this._count;
        }

        public int count() {
            return this._count;
        }
    }

    public static class InvalidIniPropertyException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        private String _sectionName;
        private String _filename;
        private String _property;

        public InvalidIniPropertyException(String filename, String sectionName, String property) {
            this._filename = filename;
            this._sectionName = sectionName;
            this._property = property;
        }

        public String getSectionName() {
            return this._sectionName;
        }

        public String getFilename() {
            return this._filename;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class InvalidIniPermissionsException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        private String _filename;

        public InvalidIniPermissionsException(String filename) {
            this._filename = filename;
        }

        public String getFilename() {
            return this._filename;
        }
    }
}

