/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class RB {
    private static ConcurrentHashMap<String, Properties> propertyCache = new ConcurrentHashMap();
    private static final String BASE_NAME = "resource";
    private static final String PROPERTY_EXT = ".properties";
    private String basePropertyFileName;
    private Properties resourceProperties;

    private RB(Object caller, String name, Locale locale) throws MissingResourceException {
        ClassLoader cl = null;
        if (caller != null) {
            String fullName;
            int pos;
            Class<?> c = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            cl = c.getClassLoader();
            if (((String)name).indexOf("/") == -1 && (pos = (fullName = c.getName()).lastIndexOf(".")) > 0) {
                name = fullName.substring(0, pos + 1).replace('.', '/') + (String)name;
            }
        }
        Locale defaultLocale = Locale.getDefault();
        if (locale != null && locale.equals(defaultLocale)) {
            locale = null;
        }
        this.loadProperties((String)name, cl, locale, defaultLocale);
    }

    private String getString(String key, Object[] array) throws MissingResourceException {
        String msg;
        if (this.resourceProperties != null && (msg = this.resourceProperties.getProperty(key)) != null) {
            try {
                return MessageFormat.format(msg, array);
            }
            catch (IllegalArgumentException ex) {
                return msg;
            }
        }
        throw new MissingResourceException("Can't find resource key \"" + key + "\" in base name " + this.basePropertyFileName, this.basePropertyFileName, key);
    }

    private void loadProperties(String basename, ClassLoader loader, Locale locale, Locale defaultLocale) throws MissingResourceException {
        Object loaderName = "";
        if (loader != null) {
            loaderName = ":" + loader.hashCode();
        }
        String cacheKey = basename + ":" + locale + ":" + defaultLocale + (String)loaderName;
        Properties p = propertyCache.get(cacheKey);
        this.basePropertyFileName = basename + PROPERTY_EXT;
        if (p == null) {
            if (locale != null) {
                p = this.loadProperties(basename, loader, locale, p);
            }
            if (defaultLocale != null) {
                p = this.loadProperties(basename, loader, defaultLocale, p);
            }
            if ((p = this.merge(p, this.loadProperties(this.basePropertyFileName, loader))) == null) {
                throw new MissingResourceException("Can't find resource for base name " + this.basePropertyFileName, this.basePropertyFileName, "");
            }
            propertyCache.put(cacheKey, p);
        }
        this.resourceProperties = p;
    }

    private Properties loadProperties(String basename, ClassLoader loader, Locale locale, Properties props) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && variant.trim().length() == 0) {
            variant = null;
        }
        if (language != null) {
            if (country != null) {
                if (variant != null) {
                    props = this.merge(props, this.loadProperties(basename + "_" + language + "_" + country + "_" + variant + PROPERTY_EXT, loader));
                }
                props = this.merge(props, this.loadProperties(basename + "_" + language + "_" + country + PROPERTY_EXT, loader));
            }
            props = this.merge(props, this.loadProperties(basename + "_" + language + PROPERTY_EXT, loader));
        }
        return props;
    }

    private Properties loadProperties(final String resname, final ClassLoader loader) {
        if (System.getSecurityManager() == null) {
            return this._loadProperties(resname, loader);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws Exception {
                    return RB.this._loadProperties(resname, loader);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties _loadProperties(String resname, ClassLoader loader) {
        Properties props = null;
        InputStream in = null;
        try {
            if (loader != null) {
                in = loader.getResourceAsStream(resname);
            }
            if (in == null) {
                in = ClassLoader.getSystemResourceAsStream(resname);
            }
            if (in != null) {
                props = new Properties();
                try {
                    props.load(in);
                }
                catch (IOException ex) {
                    props = null;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    private Properties merge(Properties p1, Properties p2) {
        if (p1 == null && p2 == null) {
            return null;
        }
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        Enumeration<Object> keysEnum = p2.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            if (p1.getProperty(key) != null) continue;
            p1.put(key, p2.getProperty(key));
        }
        return p1;
    }

    public static String getString(Object caller, String key) throws MissingResourceException {
        return RB.getMessage(caller, BASE_NAME, null, key, null);
    }

    public static String getString(Object caller, String key, Object arg0) throws MissingResourceException {
        Object[] o = new Object[]{arg0};
        return RB.getMessage(caller, BASE_NAME, null, key, o);
    }

    public static String getString(Object caller, String key, Object arg0, Object arg1) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1};
        return RB.getMessage(caller, BASE_NAME, null, key, o);
    }

    public static String getString(Object caller, String key, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2};
        return RB.getMessage(caller, BASE_NAME, null, key, o);
    }

    public static String getString(Object caller, String key, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2, arg3};
        return RB.getMessage(caller, BASE_NAME, null, key, o);
    }

    public static String getString(Object caller, String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2, arg3, arg4};
        return RB.getMessage(caller, BASE_NAME, null, key, o);
    }

    public static String getString(Object caller, String key, Object[] args) throws MissingResourceException {
        return RB.getMessage(caller, BASE_NAME, null, key, args);
    }

    public static String getString(Object caller, Locale locale, String key) throws MissingResourceException {
        return RB.getMessage(caller, BASE_NAME, locale, key, null);
    }

    public static String getString(Object caller, Locale locale, String key, Object arg0) throws MissingResourceException {
        Object[] o = new Object[]{arg0};
        return RB.getMessage(caller, BASE_NAME, locale, key, o);
    }

    public static String getString(Object caller, Locale locale, String key, Object arg0, Object arg1) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1};
        return RB.getMessage(caller, BASE_NAME, locale, key, o);
    }

    public static String getString(Object caller, Locale locale, String key, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2};
        return RB.getMessage(caller, BASE_NAME, locale, key, o);
    }

    public static String getString(Object caller, Locale locale, String key, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2, arg3};
        return RB.getMessage(caller, BASE_NAME, locale, key, o);
    }

    public static String getString(Object caller, Locale locale, String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws MissingResourceException {
        Object[] o = new Object[]{arg0, arg1, arg2, arg3, arg4};
        return RB.getMessage(caller, BASE_NAME, locale, key, o);
    }

    public static String getString(Object caller, Locale locale, String key, Object[] args) throws MissingResourceException {
        return RB.getMessage(caller, BASE_NAME, locale, key, args);
    }

    public static String getMessage(Object caller, String basename, Locale locale, String key, Object[] args) throws MissingResourceException {
        String msg = null;
        MissingResourceException firstEx = null;
        Object fullName = null;
        Class<?> curClass = null;
        if (caller != null) {
            curClass = caller instanceof Class ? (Class<?>)caller : caller.getClass();
        }
        while (msg == null) {
            String pkgName;
            int pos;
            fullName = curClass != null ? ((pos = (pkgName = curClass.getName()).lastIndexOf(".")) > 0 ? pkgName.substring(0, pos + 1).replace('.', '/') + basename : basename) : basename;
            try {
                RB rb = new RB(caller, (String)fullName, locale);
                msg = rb.getString(key, args);
            }
            catch (MissingResourceException ex) {
                Class<?> sc;
                if (curClass == null) {
                    throw ex;
                }
                if (firstEx == null) {
                    firstEx = ex;
                }
                if ((sc = curClass.getSuperclass()) == null) {
                    throw firstEx;
                }
                String cname = sc.getName();
                if (cname.startsWith("java.") || cname.startsWith("javax.")) {
                    throw firstEx;
                }
                curClass = sc;
            }
        }
        return msg;
    }
}

