/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.OleDateTime;
import coldfusion.wddx.BadCharacterDataException;
import coldfusion.wddx.ISO8601;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import java.util.Date;

class DateTimeHandler
extends WddxElement {
    private StringBuffer m_buffer = new StringBuffer();

    DateTimeHandler() {
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        try {
            String dateString = this.m_buffer.toString();
            Date dt = ISO8601.parseDate(dateString);
            if (dt == null) {
                throw new InvalidDateStringException(dateString);
            }
            try {
                this.setValue(new OleDateTime(dt));
            }
            catch (Exception ex) {
                this.setValue(dt);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new BadCharacterDataException("dataTime");
        }
        this.setType(91, "DATETIME");
    }

    @Override
    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        this.m_buffer.append(ch, start, length);
    }

    public static class InvalidDateStringException
    extends WddxDeserializationException {
        public String dateString;

        public InvalidDateStringException(String dateString) {
            this.dateString = dateString;
        }
    }

    public static class EmptyDateTimeContentException
    extends WddxDeserializationException {
    }
}

