/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.ElementFactory;
import coldfusion.wddx.WddxDefaults;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ElementFactoryMgr {
    private Hashtable m_elementFactories = new Hashtable();
    private ElementFactory m_defaultFactory;

    ElementFactoryMgr() {
        this(WddxDefaults.getProperties());
    }

    ElementFactoryMgr(Properties config) {
        ElementFactory ef = new ElementFactory();
        Enumeration<?> propNames = config.propertyNames();
        while (propNames.hasMoreElements()) {
            String pName = (String)propNames.nextElement();
            if (!pName.startsWith("deserializer.")) continue;
            String elementName = pName.substring("deserializer.".length());
            String handlerClassname = config.getProperty(pName);
            ef.registerWddxElement(elementName, handlerClassname);
        }
        this.m_elementFactories.put(new Float("0.9"), ef);
        this.m_elementFactories.put(new Float("1.0"), ef);
        this.m_defaultFactory = ef;
    }

    public ElementFactory getElementFactory(String version) {
        ElementFactory ef = (ElementFactory)this.m_elementFactories.get(new Float(version));
        if (ef == null) {
            ef = this.m_defaultFactory;
        }
        return ef;
    }
}

