/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

public class XmlNameMatcher {
    private static final boolean strictNameSpace = false;

    public static boolean isQualifiedName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != ':') continue;
            return true;
        }
        return false;
    }

    public static String getSuffix(String name) {
        char[] nameA = name.toCharArray();
        StringBuffer sb = new StringBuffer();
        String suffix = null;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ':') {
                suffix = name.substring(i + 1);
                break;
            }
            sb.append(c);
        }
        String str = new String(sb);
        if (suffix == null) {
            suffix = str;
        }
        return suffix;
    }

    public static String getPrefix(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (name.charAt(i) != ':') {
            sb.append(name.charAt(i));
            ++i;
        }
        return new String(sb);
    }

    private static boolean isStrictNameMatch(String name, String xmlName, boolean caseSensitive) {
        if (caseSensitive) {
            return name.equals(xmlName);
        }
        return name.equalsIgnoreCase(xmlName);
    }

    public static final boolean isMatch(String name, String xmlName, boolean caseSensitive) {
        if (!XmlNameMatcher.isQualifiedName(name)) {
            String xmlNameS = null;
            xmlNameS = !XmlNameMatcher.isQualifiedName(xmlName) ? xmlName : XmlNameMatcher.getSuffix(xmlName);
            if (caseSensitive) {
                return name.equals(xmlNameS);
            }
            return name.equalsIgnoreCase(xmlNameS);
        }
        return XmlNameMatcher.isStrictNameMatch(name, xmlName, caseSensitive);
    }
}

