/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.constants.CFVersions;
import java.util.HashMap;
import java.util.Map;

public class DatasourceUtil {
    public static String DRIVER = "DRIVER";
    public static String URLMAP = "urlmap";
    public static String PORT2 = "port";
    public static String _PORT = "_port";
    public static String CONNECTIONPROPS = "CONNECTIONPROPS";
    public static String HOST = "HOST";
    public static String HOST2 = "host";
    public static String PORT = "PORT";
    public static String DATABASE = "DATABASE";
    public static String DATABASE2 = "database";
    public static String QTIMEOUT = "qTimeout";
    public static String URL = "url";
    public static String MAXPOOLEDSTATEMENTS = "MaxPooledStatements";
    public static String SENDSTRINGPARAMETERASUNICODE = "sendStringParametersAsUnicode";
    public static String SELECTMETHOD = "selectMethod";
    public static String SID = "SID";
    public static String ISNEWDB = "urlmap/isnewdb";
    public static String NAME = "NAME";

    public static void appendDefaultSettings(Map map, CFVersions cfVersionFromJar) {
        switch (DRIVERS.getDriverFormName((String)map.get(DRIVER))) {
            case DB2: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getDb2Map());
                break;
            }
            case MSSQLSERVER: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getMSSQLServerMap());
                break;
            }
            case MYSQL5: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getMySQL5Map());
                break;
            }
            case POSTGRESQL: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getPostgreSQLMap());
                break;
            }
            case MYSQL_DD: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getMysqlddMap());
                break;
            }
            case APACHE_DERBY_CLIENT: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getApacheDerbyClientMap());
                break;
            }
            case ORACLE: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getOracleMap());
                break;
            }
            case APACHE_DERBY_EMBEDDED: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getApacheDerbyEmbedded());
                break;
            }
            case MSACCESS: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getMsaccessMap(cfVersionFromJar, (String)map.get(NAME)));
                break;
            }
            case ODBCSOCKET: {
                DatasourceUtil.mergeMaps(map, DatasourceUtil.getOdbcSocketMap(cfVersionFromJar, (String)map.get(NAME)));
            }
        }
        DatasourceUtil.fillCommonSettings(map, cfVersionFromJar);
    }

    private static void fillCommonSettings(Map map, CFVersions cfVersionFromJar) {
        ((Map)((Map)map.get(URLMAP)).get(CONNECTIONPROPS)).put(PORT, ((Map)map.get(URLMAP)).get(PORT2));
        ((Map)((Map)map.get(URLMAP)).get(CONNECTIONPROPS)).put(HOST, ((Map)map.get(URLMAP)).get(HOST2));
        if (((Map)map.get(URLMAP)).containsKey(SID)) {
            ((Map)((Map)map.get(URLMAP)).get(CONNECTIONPROPS)).put(SID, ((Map)map.get(URLMAP)).get(SID));
        }
        switch (DRIVERS.getDriverFormName((String)map.get(DRIVER))) {
            case DB2: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:macromedia:db2://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + ";DatabaseName=" + ((Map)map.get(URLMAP)).get(DATABASE2) + ";sendStringParametersAsUnicode=" + ((Map)map.get(URLMAP)).get(SENDSTRINGPARAMETERASUNICODE) + ";StripNewLines=true;querytimeout=" + ((Map)map.get(URLMAP)).get(QTIMEOUT) + ";MaxPooledStatements" + ((Map)map.get(URLMAP)).get(MAXPOOLEDSTATEMENTS) + ";jdbcbehavior=0");
                break;
            }
            case MSSQLSERVER: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:macromedia:sqlserver://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + ";databaseName=" + ((Map)map.get(URLMAP)).get(DATABASE2) + ";SelectMethod=" + ((Map)map.get(URLMAP)).get(SELECTMETHOD) + ";sendStringParametersAsUnicode=" + ((Map)map.get(URLMAP)).get(SENDSTRINGPARAMETERASUNICODE) + ";querytimeout=" + ((Map)map.get(URLMAP)).get(QTIMEOUT) + ";MaxPooledStatements=" + ((Map)map.get(URLMAP)).get(MAXPOOLEDSTATEMENTS) + ";jdbcbehavior=0");
                break;
            }
            case MYSQL5: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:mysql://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + "/" + ((Map)map.get(URLMAP)).get(DATABASE2) + "?tinyInt1isBit=false&");
                break;
            }
            case POSTGRESQL: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:postgresql://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + "/" + ((Map)map.get(URLMAP)).get(DATABASE2) + "?;database=" + ((Map)map.get(URLMAP)).get(DATABASE2) + ";SelectMethod=" + ((Map)map.get(URLMAP)).get(SELECTMETHOD) + ";sendStringParametersAsUnicode=" + ((Map)map.get(URLMAP)).get(SENDSTRINGPARAMETERASUNICODE) + ";host=" + ((Map)map.get(URLMAP)).get(HOST2) + ";port=" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)));
                break;
            }
            case MYSQL_DD: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:macromedia:mysql://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + ";databaseName=" + ((Map)map.get(URLMAP)).get(DATABASE2) + ";querytimeout=" + ((Map)map.get(URLMAP)).get(QTIMEOUT) + ";MaxPooledStatements=" + ((Map)map.get(URLMAP)).get(MAXPOOLEDSTATEMENTS) + ";jdbcbehavior=0");
                break;
            }
            case APACHE_DERBY_CLIENT: {
                map.put(URL, "jdbc:derby://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + "/" + ((Map)map.get(URLMAP)).get(DATABASE2));
                break;
            }
            case ORACLE: {
                ((Map)map.get(URLMAP)).put(_PORT, new Double(((Map)map.get(URLMAP)).get(PORT2).toString()));
                map.put(URL, "jdbc:macromedia:oracle://" + ((Map)map.get(URLMAP)).get(HOST2) + ":" + Util.getValueByType("int", ((Map)map.get(URLMAP)).get(PORT2)) + ";SID=" + ((Map)map.get(URLMAP)).get(SID) + ";AuthenticationMethod=userIDPassword;sendStringParametersAsUnicode=" + ((Map)map.get(URLMAP)).get(SENDSTRINGPARAMETERASUNICODE) + ";querytimeout" + ((Map)map.get(URLMAP)).get(QTIMEOUT) + ";MaxPooledStatements=" + ((Map)map.get(URLMAP)).get(MAXPOOLEDSTATEMENTS) + ";jdbcbehavior=0");
                break;
            }
            case APACHE_DERBY_EMBEDDED: {
                map.put(URL, "jdbc:derby:" + ((Map)map.get(URLMAP)).get(DATABASE2) + ";create=" + (((Map)map.get(URLMAP)).get(ISNEWDB) == null ? Boolean.valueOf(false) : ((Map)map.get(URLMAP)).get(ISNEWDB)) + ";MaxPooledStatements=" + ((Map)map.get(URLMAP)).get(MAXPOOLEDSTATEMENTS));
                break;
            }
            case MSACCESS: {
                map.put(URL, "jdbc:sequelink:msaccess://localhost:" + DatasourceUtil.getODBCSocketPort(cfVersionFromJar) + ";serverDatasource=" + map.get(NAME) + ";jdbcbehavior=0");
                break;
            }
            case ODBCSOCKET: {
                map.put(URL, "jdbc:sequelink:odbcsocket://localhost:" + DatasourceUtil.getODBCSocketPort(cfVersionFromJar) + ";serverDatasource=" + map.get(NAME) + ";jdbcbehavior=0");
            }
        }
    }

    public static void mergeMaps(Map map, Map defaultMap) {
        defaultMap.forEach((k, v) -> {
            if (!map.containsKey(k)) {
                map.put(k, v);
            } else if (v instanceof HashMap) {
                DatasourceUtil.mergeMaps((HashMap)map.get(k), (HashMap)defaultMap.get(k));
            }
        });
    }

    private static Map getOdbcSocketMap(CFVersions cfVersionFromJar, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "ODBCSocket");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("_port", new Double(DatasourceUtil.getODBCSocketPort(cfVersionFromJar).concat(".0")));
        ((HashMap)map.get("urlmap")).put("database", "");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("DATASOURCE", name);
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("PORT", DatasourceUtil.getODBCSocketPort(cfVersionFromJar));
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("HOST", "localhost");
        ((HashMap)map.get("urlmap")).put("host", "localhost");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", false);
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("port", DatasourceUtil.getODBCSocketPort(cfVersionFromJar));
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        map.put("username", "system");
        return map;
    }

    private static String getODBCSocketPort(CFVersions cfVersionFromJar) {
        switch (cfVersionFromJar) {
            case CF2016: {
                return "20006";
            }
            case CF2018: {
                return "20008";
            }
            case CF2021: {
                return "20010";
            }
        }
        return "20012";
    }

    private static Map getMsaccessMap(CFVersions cfVersionFromJar, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "MSAccess");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("_port", new Double(DatasourceUtil.getODBCSocketPort(cfVersionFromJar).concat(".0")));
        ((HashMap)map.get("urlmap")).put("database", "");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("PORT", DatasourceUtil.getODBCSocketPort(cfVersionFromJar));
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("DATASOURCE", name);
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("HOST", "localhost");
        ((HashMap)map.get("urlmap")).put("host", "localhost");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", true);
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("port", DatasourceUtil.getODBCSocketPort(cfVersionFromJar));
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("pageTimeout", new Double("600.0"));
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", false);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        map.put("username", "");
        map.put("password", "");
        return map;
    }

    private static Map getApacheDerbyEmbedded() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "Apache Derby Embedded");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "org.apache.derby.jdbc.EmbeddedDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("TYPE", "ddtek");
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("MAXPOOLEDSTATEMENTS", new Double("300.0"));
        ((HashMap)map.get("urlmap")).put("host", "");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", new Double("300.0"));
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "true");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("port", "");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("VENDOR", "Apache Derby");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "jdbc:derby:C:/Work/;create=true;MaxPooledStatements=300");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        map.put("username", "");
        return map;
    }

    private static Map getOracleMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "Oracle");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("TYPE", "ddtek");
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", false);
        ((HashMap)map.get("urlmap")).put("database", "");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("SENDSTRINGPARAMETERSASUNICODE", false);
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("MAXPOOLEDSTATEMENTS", "100");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("QTIMEOUT", "0");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("VENDOR", "oracle");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("serviceName", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getApacheDerbyClientMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "Apache Derby Client");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "org.apache.derby.jdbc.ClientDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "jdbc:derby://localhost:1234/ex6");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getMysqlddMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "MySQL_DD");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "password");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", false);
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("SENDSTRINGPARAMETERSASUNICODE", false);
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("MAXPOOLEDSTATEMENTS", "100");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("QTIMEOUT", "0");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getPostgreSQLMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "PostgreSQL");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "org.postgresql.Driver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getMySQL5Map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "MySQL5");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "com.mysql.jdbc.Driver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getMSSQLServerMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "MSSQLServer");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("TYPE", "ddtek");
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", "false");
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("SELECTMETHOD", "direct");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("SENDSTRINGPARAMETERSASUNICODE", "false");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("MAXPOOLEDSTATEMENTS", "100");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("QTIMEOUT", "0");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("APPLICATIONINTENT", "");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("VENDOR", "sqlserver");
        ((HashMap)map.get("urlmap")).put("CF_POOLED", true);
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    private static Map getDb2Map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("drop", true);
        map.put("storedproc", true);
        map.put("validationQuery", "");
        map.put("select", true);
        map.put("clientinfo", new HashMap());
        ((HashMap)map.get("clientinfo")).put("ApplicationName", false);
        ((HashMap)map.get("clientinfo")).put("ApplicationNamePrefix", "");
        ((HashMap)map.get("clientinfo")).put("ClientHostName", false);
        ((HashMap)map.get("clientinfo")).put("ClientUser", false);
        map.put("disable_clob", true);
        map.put("DRIVER", "DB2");
        map.put("description", "");
        map.put("update", true);
        map.put("revoke", true);
        map.put("insert", true);
        map.put("CLASS", "macromedia.jdbc.MacromediaDriver");
        map.put("delete", true);
        map.put("timeout", new Double("1200.0"));
        map.put("blob_buffer", new Double("64000.0"));
        map.put("password", "");
        map.put("create", true);
        map.put("buffer", new Double("64000.0"));
        map.put("login_timeout", new Double("30.0"));
        map.put("TYPE", "ddtek");
        map.put("alter", true);
        map.put("disable_autogenkeys", false);
        map.put("disable_blob", true);
        map.put("urlmap", new HashMap());
        ((HashMap)map.get("urlmap")).put("informixServer", "");
        ((HashMap)map.get("urlmap")).put("applicationintent", "");
        ((HashMap)map.get("urlmap")).put("useSpyLog", false);
        ((HashMap)map.get("urlmap")).put("databaseFile", "");
        ((HashMap)map.get("urlmap")).put("supportLinks", "true");
        ((HashMap)map.get("urlmap")).put("sendStringParametersAsUnicode", false);
        ((HashMap)map.get("urlmap")).put("CONNECTIONPROPS", new HashMap());
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("SENDSTRINGPARAMETERSASUNICODE", false);
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("MAXPOOLEDSTATEMENTS", "100");
        ((HashMap)((HashMap)map.get("urlmap")).get("CONNECTIONPROPS")).put("QTIMEOUT", "0");
        ((HashMap)map.get("urlmap")).put("MaxPooledStatements", "100");
        ((HashMap)map.get("urlmap")).put("maxBufferSize", "");
        ((HashMap)map.get("urlmap")).put("defaultpassword", "");
        ((HashMap)map.get("urlmap")).put("systemDatabaseFile", "");
        ((HashMap)map.get("urlmap")).put("isnewdb", "false");
        ((HashMap)map.get("urlmap")).put("UseTrustedConnection", "false");
        ((HashMap)map.get("urlmap")).put("selectMethod", "direct");
        ((HashMap)map.get("urlmap")).put("spyLogFile", "");
        ((HashMap)map.get("urlmap")).put("SID", "");
        ((HashMap)map.get("urlmap")).put("args", "");
        ((HashMap)map.get("urlmap")).put("defaultusername", "");
        ((HashMap)map.get("urlmap")).put("TimeStampAsString", "no");
        ((HashMap)map.get("urlmap")).put("datasource", "");
        ((HashMap)map.get("urlmap")).put("VENDOR", "db2");
        ((HashMap)map.get("urlmap")).put("pageTimeout", "");
        ((HashMap)map.get("urlmap")).put("qTimeout", "0");
        ((HashMap)map.get("urlmap")).put("_logintimeout", new Double("30.0"));
        map.put("url", "");
        map.put("validateConnection", false);
        map.put("pooling", true);
        map.put("disable", false);
        map.put("ISJ2EE", false);
        map.put("interval", new Double("420.0"));
        map.put("grant", true);
        return map;
    }

    public static enum DRIVERS {
        DB2("DB2"),
        MSSQLSERVER("MSSQLServer"),
        MYSQL5("MySQL5"),
        POSTGRESQL("PostgreSQL"),
        MYSQL_DD("MySQL_DD"),
        APACHE_DERBY_CLIENT("Apache Derby Client"),
        ORACLE("Oracle"),
        APACHE_DERBY_EMBEDDED("Apache Derby Embedded"),
        MSACCESS("MSAccess"),
        ODBCSOCKET("ODBCSocket");

        String name;

        private DRIVERS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DRIVERS getDriverFormName(String driverName) {
            DRIVERS driver = null;
            for (DRIVERS d : DRIVERS.values()) {
                if (!d.getName().equalsIgnoreCase(driverName)) continue;
                driver = d;
                break;
            }
            return driver;
        }
    }
}

