/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.constants.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class KeytoolUtils {
    private final String sslKeyStoreLocation;

    public KeytoolUtils(String sslKeyStoreLocation) {
        this.sslKeyStoreLocation = sslKeyStoreLocation;
    }

    public boolean generateKeyAndCertificate(String dname, String keystoreFileName, String password) {
        boolean retVal = this.generateCertificate(dname, keystoreFileName, password);
        if (retVal) {
            retVal = this.generatePublicKey(keystoreFileName, password);
        }
        return retVal;
    }

    private String getConfPathWithFilename(String fileName) {
        return this.sslKeyStoreLocation + File.separator + fileName;
    }

    private boolean generateCertificate(String dname, String keystoreFileName, String password) {
        String confPathWithFileName = this.getConfPathWithFilename(keystoreFileName);
        String alias = keystoreFileName.split("\\.")[0];
        File keystoreFile = new File(confPathWithFileName);
        if (keystoreFile.exists()) {
            MessageHandler.getInstance().showError(Messages.getString("ssl.keystoreFileExists", keystoreFileName));
            return false;
        }
        String command = " -genkeypair  -alias " + alias + " -keyalg RSA  -sigalg SHA256withRSA  -dname " + dname + " -validity 365 -storetype pkcs12  -keypass " + password + " -keystore " + confPathWithFileName + " -storepass " + password;
        boolean success = this.execute(command);
        if (success) {
            MessageHandler.getInstance().showInfo(Messages.getString("ssl.keystoreFileCreatedSuccessfully", confPathWithFileName));
        } else {
            MessageHandler.getInstance().showError(Messages.getString("ssl.keystoreFileCreationFail"));
        }
        return success;
    }

    private boolean generatePublicKey(String keystoreFileName, String password) {
        String fileNameWithoutExtension = keystoreFileName.split("\\.")[0];
        String publicKeyFileName = fileNameWithoutExtension + "_public.pem";
        String confPathWithKeyStoreName = this.getConfPathWithFilename(keystoreFileName);
        String confPathWithPublicKeyFileName = this.getConfPathWithFilename(publicKeyFileName);
        File publicKeyFile = new File(confPathWithPublicKeyFileName);
        String command = " -export  -alias " + fileNameWithoutExtension + " -keystore " + confPathWithKeyStoreName + " -rfc -file " + confPathWithPublicKeyFileName + " -storepass " + password;
        boolean success = this.execute(command);
        if (success) {
            MessageHandler.getInstance().showInfo(Messages.getString("ssl.publickeyFileCreatedSuccessfully", confPathWithPublicKeyFileName));
        } else {
            MessageHandler.getInstance().showError(Messages.getString("ssl.publickeyFileCreationFail"));
        }
        return success;
    }

    public boolean execute(String command) {
        try {
            String[] options = this.parse(command);
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("keytool");
            commandList.addAll(Arrays.asList(options));
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception ex) {
            MessageHandler.getInstance().showInfo(Messages.getString("ssl.keytoolExecuteFail", ex.getClass().getSimpleName(), ex.getMessage()));
            return false;
        }
    }

    private String[] parse(String command) {
        String[] options = command.trim().split("\\s+");
        return options;
    }
}

