/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Encryptor;
import coldfusion.runtime.Struct;
import coldfusion.security.SecurityUtils;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.FileUtils;
import coldfusion.wddx.Base64Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Properties;
import java.util.Random;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils
extends Observable {
    private static final char PADCHAR = '#';
    private static final String DESALGORITHM = "DESede";
    private static final String AES_CBC_PKCS5_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String SEEDFILE = "seed.properties";
    private static final String BASEENCODING = "Base64";
    private static final String DEFAULT_ENCODING = "UU";
    public static final String SEED = "seed";
    public static final String ALGORITHM = "algorithm";
    public static final String SEEDINFO = "seedInfo";
    public static final String CURRENT_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final int FORAES_START_MAJOR_VERSION = 9;
    public static final int FORAES_START_MINOR_VERSION = 5;
    private static String ROOTDIR;
    private static String SEEDFILEPATH;
    private static PasswordUtils instance;
    private String seedValue;
    private Properties seedProperties = new Properties();
    private static File seedFileObj;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordUtils getInstance(String rootDir) throws ServiceException {
        Class<PasswordUtils> clazz = PasswordUtils.class;
        synchronized (PasswordUtils.class) {
            if (instance == null) {
                ROOTDIR = rootDir;
                SEEDFILEPATH = ROOTDIR + File.separatorChar + "lib" + File.separatorChar + SEEDFILE;
                instance = new PasswordUtils();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static PasswordUtils getInstance() {
        return instance;
    }

    private PasswordUtils() throws ServiceException {
        this.loadSeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadSeed(String seedPath) throws ServiceException {
        File seedFileObj = new File(seedPath);
        FileInputStream finput = null;
        Properties seedProperties = new Properties();
        try {
            finput = new FileInputStream(seedFileObj);
            seedProperties.load(finput);
        }
        catch (Throwable t) {
            if (seedFileObj.exists()) {
                throw new ServiceException(t);
            }
        }
        finally {
            try {
                finput.close();
            }
            catch (Throwable throwable) {}
        }
        String seed = seedProperties.getProperty(SEED);
        String algoValue = seedProperties.getProperty(ALGORITHM);
        if (seed != null && algoValue != null && seed.length() > 0 && algoValue.length() > 0) {
            String seedValue = seed;
            if (!algoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding")) {
                throw new SeedException();
            }
        }
        return seedProperties;
    }

    private void loadSeed() throws ServiceException {
        seedFileObj = new File(SEEDFILEPATH);
        FileInputStream finput = null;
        try {
            finput = new FileInputStream(seedFileObj);
            this.seedProperties.load(finput);
        }
        catch (Throwable t) {
            if (seedFileObj.exists()) {
                throw new ServiceException(t);
            }
        }
        finally {
            try {
                finput.close();
            }
            catch (Throwable throwable) {}
        }
        String seed = this.seedProperties.getProperty(SEED);
        String algoValue = this.seedProperties.getProperty(ALGORITHM);
        if (seed != null && algoValue != null && seed.length() > 0 && algoValue.length() > 0) {
            this.seedValue = seed;
            if (!algoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding")) {
                throw new SeedException();
            }
        }
    }

    public void setSeed(String seedVal) throws Exception {
        if (seedVal == null) {
            throw new RuntimeException("Seed cannot be null");
        }
        String digest = SecurityUtils.hash(seedVal, "SHA-256", "", "");
        seedVal = digest.substring(0, 16);
        if (seedVal.equals(this.seedValue)) {
            return;
        }
        this.seedValue = seedVal;
        this.seedProperties.setProperty(SEED, this.seedValue);
        this.storeSeedProperties();
        this.setChanged();
        this.notifyObservers(this.seedValue);
    }

    public String getSeedValue() {
        return this.seedValue;
    }

    public static String reEncryptWithNewSeed(String encryptedStr, String oldSeed, String newSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        return PasswordUtils.reEncryptWithNewSeed(encryptedStr, oldSeed, newSeed, false, oldAlgoValue, majorVersion, minorVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String reEncryptWithNewSeed(String encryptedStr, String oldSeed, String newSeed, boolean noEncodingForDecryption, String oldAlgoValue, int majorVersion, int minorVersion) {
        if (encryptedStr == null || encryptedStr != null && encryptedStr.equals("")) {
            return encryptedStr;
        }
        if (majorVersion == 0) {
            throw new SeedException();
        }
        if (!PasswordUtils.isAESS(majorVersion, minorVersion)) return PasswordUtils.encryptWithAES_CBC_PKCS5(PasswordUtils.decryptWith3DES(encryptedStr, oldSeed, noEncodingForDecryption), newSeed);
        if (oldAlgoValue == null || oldAlgoValue.length() <= 0) throw new SeedException();
        if (oldAlgoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding") && oldSeed.equals(newSeed)) {
            return encryptedStr;
        }
        if (!oldAlgoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding")) return encryptedStr;
        return PasswordUtils.encryptWithAES_CBC_PKCS5(PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedStr, oldSeed), newSeed);
    }

    public static String reEncryptForSM(String encryptedStr, String oldSeed, String newSeed) {
        if (encryptedStr == null || encryptedStr != null && encryptedStr.equals("")) {
            return encryptedStr;
        }
        if (oldSeed != null && oldSeed.equals(newSeed)) {
            return encryptedStr;
        }
        return PasswordUtils.encryptWith3DES(PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedStr, oldSeed), newSeed);
    }

    public static String decryptPassword(String encryptedPassword, String seedval, String algoValue) {
        if (encryptedPassword == null || encryptedPassword != null && encryptedPassword.equals("")) {
            return encryptedPassword;
        }
        if (seedval == null) {
            throw new RuntimeException("Seed passed for encryption in null.");
        }
        String pwd = null;
        if (algoValue != null && algoValue.length() > 0) {
            if (algoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding")) {
                pwd = PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedPassword, seedval);
            } else {
                logger.error("Unknown Algorithm Specified.");
                PasswordUtils passwordUtils = instance;
                Objects.requireNonNull(passwordUtils);
                throw passwordUtils.new UnknownAlgorithmException("Unknown Algorithm Specified.");
            }
        }
        return pwd;
    }

    public static String decryptPassword(String encryptedPassword, String seedval) {
        if (encryptedPassword == null || encryptedPassword != null && encryptedPassword.equals("")) {
            return encryptedPassword;
        }
        if (seedval == null) {
            throw new RuntimeException("Seed passed for encryption in null.");
        }
        String pwd = null;
        pwd = PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedPassword, seedval);
        return pwd;
    }

    public static String encryptPassword(String p, String seedval) {
        if (p == null || p != null && p.equals("")) {
            return p;
        }
        if (seedval == null) {
            throw new RuntimeException("Seed passed for encryption in null.");
        }
        return PasswordUtils.encryptWithAES_CBC_PKCS5(p, seedval);
    }

    public static String encryptWith3DES(String p, String seedval) {
        String secKey = Encryptor.generate3DesKey(seedval);
        return Encryptor.encrypt(p, secKey, DESALGORITHM, BASEENCODING, null, 0);
    }

    private static String decryptWith3DES(String encryptedPassword, String seedval, boolean noEncodingForDecryption) {
        String secKey = Encryptor.generate3DesKey(seedval);
        String pwd = noEncodingForDecryption ? Encryptor.decrypt(encryptedPassword, secKey, DESALGORITHM, DEFAULT_ENCODING, null, 0) : Encryptor.decrypt(encryptedPassword, secKey, DESALGORITHM, BASEENCODING, null, 0);
        return pwd;
    }

    private static String decryptWithAES_CBC_PKCS5(String encryptedPassword, String seedval) {
        String secKey = PasswordUtils.generateAesKey(seedval);
        return Encryptor.decrypt(encryptedPassword, secKey, "AES/CBC/PKCS5Padding", BASEENCODING, null, 0);
    }

    private static String decryptWithAES_CBC_PKCS5(String encryptedPassword, String seedval, String enc) {
        String secKey = PasswordUtils.generateAesKey(seedval);
        if (enc != null && enc.length() > 0) {
            return Encryptor.decrypt(encryptedPassword, secKey, "AES/CBC/PKCS5Padding", enc, null, 0);
        }
        return Encryptor.decrypt(encryptedPassword, secKey, "AES/CBC/PKCS5Padding", BASEENCODING, null, 0);
    }

    private static String encryptWithAES_CBC_PKCS5(String p, String seedval) {
        String secKey = PasswordUtils.generateAesKey(seedval);
        return Encryptor.encrypt(p, secKey, "AES/CBC/PKCS5Padding", BASEENCODING, null, 0);
    }

    private static String encryptWithAES_CBC_PKCS5(String p, String seedval, String enc) {
        String secKey = PasswordUtils.generateAesKey(seedval);
        if (enc != null && enc.length() > 0) {
            return Encryptor.encrypt(p, secKey, "AES/CBC/PKCS5Padding", enc, null, 0);
        }
        return Encryptor.encrypt(p, secKey, "AES/CBC/PKCS5Padding", BASEENCODING, null, 0);
    }

    private static String generateAesKey(String seed) {
        if (seed == null || seed != null && seed.length() == 0) {
            throw new SeedException();
        }
        byte[] seedBytes = null;
        try {
            seedBytes = seed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            seedBytes = seed.getBytes();
        }
        int seedLen = seedBytes.length;
        seedBytes = Arrays.copyOf(seedBytes, 16);
        if (seedLen < 16) {
            for (int i = seedLen; i < 16; ++i) {
                seedBytes[i] = 35;
            }
        }
        SecretKeySpec secretKey = new SecretKeySpec(seedBytes, "AES");
        return Base64Encoder.encode(secretKey.getEncoded());
    }

    private final void storeSeedProperties() {
        FileOutputStream foutput = null;
        try {
            foutput = new FileOutputStream(SEEDFILEPATH);
            this.seedProperties.store(foutput, null);
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
        finally {
            if (foutput != null) {
                try {
                    foutput.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            FileUtils.setUnixModes(SEEDFILEPATH, 600);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadSeedForMigration(String filePath) throws ServiceException {
        String algoValue;
        String seed;
        String digest;
        Struct struct = new Struct();
        Properties props = new Properties();
        FileInputStream finput = null;
        File seedPropertiesFile = new File(filePath);
        if (filePath == null) {
            return struct;
        }
        if (seedPropertiesFile != null && !seedPropertiesFile.exists() && (digest = PasswordUtils.hash()) != null) {
            digest = digest.substring(0, 16);
            seedPropertiesFile.setExecutable(false, false);
            seedPropertiesFile.setReadable(true, true);
            seedPropertiesFile.setWritable(true, true);
            FileWriter writer = null;
            try {
                writer = new FileWriter(seedPropertiesFile);
                writer.write("seed=" + digest + "\n");
                writer.write("algorithm=AES/CBC/PKCS5Padding");
            }
            catch (Exception exception) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            if (seedFileObj != null && seedPropertiesFile != null && seedFileObj.getCanonicalPath().equalsIgnoreCase(seedPropertiesFile.getCanonicalPath())) {
                finput = new FileInputStream(seedFileObj);
                props.load(finput);
                seed = props.getProperty(SEED);
                algoValue = props.getProperty(ALGORITHM);
                if (seed != null && algoValue != null && seed.length() > 0 && algoValue.length() > 0) {
                    if (!algoValue.equalsIgnoreCase("AES/CBC/PKCS5Padding")) {
                        throw new SeedException();
                    }
                    struct.put(SEED, seed);
                    struct.put(ALGORITHM, algoValue);
                    return struct;
                }
                throw new SeedException();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            finput = new FileInputStream(seedPropertiesFile);
            props.load(finput);
        }
        catch (Throwable t) {
        }
        finally {
            try {
                finput.close();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
        if (props != null) {
            seed = props.getProperty(SEED);
            algoValue = props.getProperty(ALGORITHM);
            if (seed != null && seed.length() > 0) {
                struct.put(SEED, seed);
            }
            if (algoValue != null && algoValue.length() > 0) {
                struct.put(ALGORITHM, algoValue);
            }
        }
        return struct;
    }

    public static String hash() {
        byte[] input;
        MessageDigest digest;
        String string = new String(PasswordUtils.generateRandom());
        String encoding = "UTF-8";
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.reset();
        try {
            input = string.getBytes(encoding);
            digest.update(input);
            input = digest.digest();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return PasswordUtils.stringify(input);
    }

    public static byte[] generateRandom() {
        int numBytes = 20;
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[numBytes];
        ((Random)r).nextBytes(salt);
        return salt;
    }

    public static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    public static boolean isAESS(int majorVersion, int minorVersion) {
        return majorVersion > 9 || majorVersion == 9 && minorVersion == 5;
    }

    public static String encryptWithEncoding(String p, String seedval, String enc) {
        if (p == null || p != null && p.equals("")) {
            return p;
        }
        if (seedval == null) {
            throw new RuntimeException("Seed passed for encryption in null.");
        }
        return PasswordUtils.encryptWithAES_CBC_PKCS5(p, seedval, enc);
    }

    public static String decryptWithEncoding(String encryptedPassword, String seedval, String enc) {
        if (encryptedPassword == null || encryptedPassword != null && encryptedPassword.equals("")) {
            return encryptedPassword;
        }
        if (seedval == null) {
            throw new RuntimeException("Seed passed for encryption in null.");
        }
        String pwd = null;
        pwd = PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedPassword, seedval, enc);
        return pwd;
    }

    public static String reEncryptWithNewSeed(String encryptedStr, String oldSeed, String newSeed) {
        if (encryptedStr == null || encryptedStr != null && encryptedStr.equals("")) {
            return encryptedStr;
        }
        if (oldSeed != null && oldSeed.equals(newSeed)) {
            return encryptedStr;
        }
        return PasswordUtils.encryptWithAES_CBC_PKCS5(PasswordUtils.decryptWithAES_CBC_PKCS5(encryptedStr, oldSeed), newSeed);
    }

    static {
        instance = null;
        logger = LoggerFactory.getLogger(PasswordUtils.class);
    }

    public static class SeedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class UnknownAlgorithmException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public UnknownAlgorithmException(String msg) {
            super(msg);
        }
    }
}

