/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import coldfusion.server.centralConfigServer.CentralConfigServerUtil;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutionPipeline {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutionPipeline.class);
    private final SettingInstanceProvider settingInstanceProvider = SettingInstanceProvider.getInstance();
    public static final CommandExecutionPipeline PIPELINE = new CommandExecutionPipeline();

    private CommandExecutionPipeline() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer submitToPipeline(AbstractCommand command) {
        ExitStatus status = ExitStatus.FAIL;
        try {
            boolean result;
            boolean bl = result = CommandExecutionPipeline.parseCommand(command) && this.validateCategory(command);
            if (result) {
                this.populateCategorySetting(command);
            }
            boolean bl2 = result = result && this.validateCommand(command);
            if (result) {
                status = this.executeCommand(command);
                return status;
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred in pipeline", (Throwable)e);
            status = ExitStatus.FAIL;
            return status;
        }
        finally {
            command.reset();
            Util.showExitMessage(status);
            return status.getVal();
        }
    }

    private boolean validateCategory(AbstractCommand command) {
        if (Objects.nonNull((Object)command.getCommandInfo().getCategory())) {
            boolean isEnterprise;
            File executionFile = this.getExecutionFileObject(command);
            boolean isCfHome = Util.validCFHome(executionFile);
            boolean bl = isEnterprise = isCfHome && Util.isJEEDeployment(executionFile.getAbsolutePath());
            if (isEnterprise && Arrays.asList(Category.JVM, Category.SERVER).contains((Object)command.getCommandInfo().getCategory())) {
                MessageHandler.getInstance().showWarning("Category disabled in " + this.getRuntime() + " :" + command.getCommandInfo().getCategory().name());
                return false;
            }
            if (isCfHome && Util.isCategoryDisabled(executionFile.getAbsolutePath(), command.getCommandInfo().getCategory().name())) {
                MessageHandler.getInstance().showWarning("Category disabled :" + command.getCommandInfo().getCategory().name());
                return false;
            }
        }
        return true;
    }

    private String getRuntime() {
        return AbstractCommand.isLambdaMode() ? "Serverless" : "jee";
    }

    private ExitStatus executeCommand(AbstractCommand command) {
        return command.runCommand();
    }

    private boolean validateCommand(AbstractCommand command) {
        return command.validateCommand();
    }

    private void populateCategorySetting(AbstractCommand command) {
        File executionLocation = this.getExecutionLocation(command);
        try {
            if (this.doesCommandModifySettings(command)) {
                CentralConfigServerUtil util = new CentralConfigServerUtil();
                util.isCCSEnabledButNotRunning(executionLocation);
            }
        }
        catch (Throwable util) {
            // empty catch block
        }
        GenericSetting genericSetting = this.settingInstanceProvider.getCategoryInstance(executionLocation, command.getCommandInfo().getCategory(), command.isUseCachedSetting());
        command.setGenericSetting(genericSetting);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doesCommandModifySettings(AbstractCommand command) {
        if (command == null) return false;
        if (AbstractCommand.commandName == null) return false;
        if (AbstractCommand.commandName.equals((Object)CommandName.SET)) return true;
        if (AbstractCommand.commandName.equals((Object)CommandName.DELETE)) return true;
        if (AbstractCommand.commandName.equals((Object)CommandName.IMPORT)) return true;
        if (!AbstractCommand.commandName.equals((Object)CommandName.ADD)) return false;
        return true;
    }

    private File getExecutionLocation(AbstractCommand command) {
        File executionFile = this.getExecutionFileObject(command);
        if (Objects.nonNull(executionFile)) {
            if (!executionFile.exists()) {
                logger.error(String.format("File does not exist: %s", executionFile.getAbsolutePath()));
                String messageId = "invalidInstance";
                if (executionFile.getAbsolutePath().contains(".json")) {
                    messageId = "fileNotFound";
                }
                return null;
            }
            if (!executionFile.getAbsolutePath().contains(".json") && !Util.validCFHome(executionFile)) {
                return null;
            }
        }
        command.setExecutionFile(executionFile);
        return executionFile;
    }

    private File getExecutionFileObject(AbstractCommand command) {
        String executionPath = command.getCommandInfo().getExecutionPath();
        if (StringUtils.isBlank((CharSequence)executionPath)) {
            if (StringUtils.isNotBlank((CharSequence)RegisterInstanceImpl.getInstance().getSelectedInstPath())) {
                command.setUseCachedSetting(true);
                return new File(RegisterInstanceImpl.getInstance().getSelectedInstPath());
            }
            return null;
        }
        if (executionPath.endsWith(".json")) {
            return new File(executionPath);
        }
        String instancePath = RegisterInstanceImpl.getInstanceLocationFromAlias(executionPath);
        if (!StringUtils.isBlank((CharSequence)instancePath)) {
            if (StringUtils.isNotBlank((CharSequence)RegisterInstanceImpl.getInstance().getSelectedInstPath()) && instancePath.equals(RegisterInstanceImpl.getInstance().getSelectedInstPath())) {
                command.setUseCachedSetting(true);
            }
            return new File(instancePath);
        }
        return new File(executionPath);
    }

    private static boolean parseCommand(AbstractCommand command) {
        CommandInfo commandInfo = command.parseCommand();
        command.setCommandInfo(commandInfo);
        return Objects.nonNull(commandInfo);
    }
}

