/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.PrettyXMLConfiguration;
import java.io.File;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public abstract class ConfigurationBase
implements GenericSetting {
    private static XMLConfiguration cfg;
    protected static String selectedPath;

    public ConfigurationBase(String instancePath) {
        selectedPath = instancePath;
    }

    public static XMLConfiguration getParsedConfigObject(File file) {
        cfg = ConfigurationBase.parseConfigInstance(file);
        return cfg;
    }

    public String getSelectedPath() {
        return selectedPath;
    }

    public abstract String getXMLFileName();

    public abstract XMLConfiguration getCfg();

    public abstract void populateMap();

    public abstract List<String> getAllXmlAttributes();

    public abstract List<String> getValuesforKeys(List<String> var1);

    public abstract String getSetting(String var1);

    public abstract boolean setSetting(String var1, String var2);

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.setSetting(name, String.valueOf(value));
    }

    @Override
    public String getSetting(String name, String service) {
        return this.getSetting(name);
    }

    public static XMLConfiguration parseConfigInstance(File file) {
        PrettyXMLConfiguration config = null;
        try {
            config = new PrettyXMLConfiguration(file);
            config.setDelimiterParsingDisabled(true);
            config.setAttributeSplittingDisabled(true);
            XMLConfiguration.setDefaultListDelimiter((char)'~');
        }
        catch (ConfigurationException e) {
            System.err.println("Exception while initializing config object");
        }
        return config;
    }
}

