/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MultiConfigurationBase
implements GenericSetting {
    protected static final String TAB = "\t";
    protected XMLConfiguration cfg;
    public String selectedPath;
    private Integer LINE_LIMIT = 50;

    public XMLConfiguration getCfg() {
        return null;
    }

    public abstract void populateMap();

    public MultiConfigurationBase(String instancePath) {
        this.selectedPath = instancePath;
    }

    @Override
    public void show(String service) {
        TreeMap<String, Object> internalMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        internalMap.putAll(this.getInternalMap());
        this.putDependentSettings(internalMap);
        Map<String, Object> map = this.sortMap(internalMap, 0);
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)this.getCategory().name().toLowerCase().concat(this.showSuffix())), true);
            if (MapUtils.isEmpty(map)) {
                MessageHandler.getInstance().showInfo(TAB + Messages.getString("NoSettingsFound"));
                return;
            }
            map.forEach((sname, value) -> {
                if (value instanceof Map) {
                    if ("*".equals(service) || !(this instanceof MultilevelSetting)) {
                        MessageHandler.getInstance().showBlueAndBold(TAB + sname + ":", true);
                        this.printMap((Map)value, TAB);
                    } else {
                        MessageHandler.getInstance().showInfo((String)sname);
                    }
                } else if (value instanceof Collection) {
                    MessageHandler.getInstance().showGreen(TAB + sname + " : ", true);
                    this.printCollection((Collection)value, "\t\t");
                } else {
                    String userDefinedName = sname;
                    if (!Objects.isNull(userDefinedName)) {
                        String stringValue;
                        if (value instanceof MapObject) {
                            MessageHandler.getInstance().showGreen(TAB + userDefinedName + ": ", false);
                            stringValue = ((MapObject)value).getValue();
                        } else {
                            MessageHandler.getInstance().showGreen(TAB + userDefinedName + ": ", false);
                            stringValue = String.valueOf(value);
                        }
                        String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                        stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                        MessageHandler.getInstance().showInfo(stringValue);
                    }
                }
            });
            return;
        }
        if (!internalMap.containsKey(service)) {
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        Object value2 = map.get(service);
        if (value2 instanceof Map) {
            MessageHandler.getInstance().showGreenAndBold(service + ":", true);
            this.printMap((Map)value2, "");
        } else if (value2 instanceof Collection) {
            MessageHandler.getInstance().showGreen(service + ":", true);
            this.printCollection((Collection)value2, "");
        } else {
            String userDefinedName = service;
            if (!Objects.isNull(userDefinedName)) {
                String stringValue = value2 instanceof MapObject ? ((MapObject)value2).getValue() : String.valueOf(value2);
                String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                MessageHandler.getInstance().showGreen(TAB + userDefinedName + ": ", false);
                MessageHandler.getInstance().showInfo(stringValue);
            }
        }
    }

    protected void putDependentSettings(Map<String, Object> map) {
        Map<String, ValidationDetails> validationDetailsMap = SettingValidation.getInstance().getcategoryValidationMap(this.getCategory());
        File executionPath = new File(this.selectedPath);
        validationDetailsMap.forEach((k, v) -> {
            Pair<GenericSetting, String> genericSettingKeyPair;
            if (StringUtils.isNotBlank((CharSequence)v.getExternal()) && (genericSettingKeyPair = Util.getExternalDependency(this.getCategory(), k, executionPath)) != null) {
                GenericSetting genericSetting = (GenericSetting)genericSettingKeyPair.getLeft();
                String actualSetting = (String)genericSettingKeyPair.getRight();
                map.put((String)k, genericSetting.getSetting(actualSetting, null));
            }
        });
    }

    protected Map<String, Object> sortMap(Map<String, Object> map, Integer level) {
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String userDefinedName;
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof Map) {
                if (0 != level) {
                    if (SettingValidation.getInstance().getValidationDetail(this.getCategory(), key).isRestricted()) continue;
                    userDefinedName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), key);
                    userDefinedName = userDefinedName == null ? key : userDefinedName;
                    finalMap.put(userDefinedName, this.sortMap((Map)value, level + 1));
                    continue;
                }
                finalMap.put(key, this.sortMap((Map)value, level + 1));
                continue;
            }
            if (SettingValidation.getInstance().getValidationDetail(this.getCategory(), key).isRestricted()) continue;
            userDefinedName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), key);
            userDefinedName = userDefinedName == null ? key : userDefinedName;
            finalMap.put(userDefinedName, value);
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        sortedMap.putAll(finalMap);
        return sortedMap;
    }

    protected void printMap(Map value, String tabs) {
        String currentTab = tabs + TAB;
        value.forEach((key, object) -> {
            if (object instanceof Map) {
                MessageHandler.getInstance().showWhiteAndBold(currentTab + key + " : ", true);
                this.printMap((Map)object, currentTab);
            } else if (object instanceof Collection) {
                MessageHandler.getInstance().showGreen(currentTab + key + " : ", true);
                this.printCollection((Collection)object, currentTab);
            } else {
                String userDefinedName = (String)key;
                if (!Objects.isNull(userDefinedName)) {
                    String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                    String stringValue = object instanceof MapObject ? ((MapObject)object).getValue() : String.valueOf(object);
                    stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                    MessageHandler.getInstance().showGreen(currentTab + userDefinedName + ": ", false);
                    MessageHandler.getInstance().showInfo(stringValue);
                }
            }
        });
    }

    protected void printCollection(Collection object, String currentTab) {
        int currlen = 0;
        boolean isStringCollection = true;
        for (Object o : object) {
            if (o instanceof String) continue;
            isStringCollection = false;
            break;
        }
        if (isStringCollection) {
            object = new TreeSet(object);
        }
        for (Object o : object) {
            if (o instanceof Map) {
                this.printMap((Map)o, currentTab);
                continue;
            }
            String stringValue = o instanceof MapObject ? ((MapObject)o).getValue() : String.valueOf(o);
            int wordlen = stringValue.length() + 1;
            if (currlen + wordlen <= this.LINE_LIMIT && currlen != 0) {
                MessageHandler.getInstance().showInfo(" " + stringValue, false);
                currlen += wordlen;
                continue;
            }
            if (currlen != 0) {
                MessageHandler.getInstance().showInfo("");
            }
            MessageHandler.getInstance().showInfo(currentTab + stringValue, false);
            currlen = wordlen;
        }
        if (CollectionUtils.isNotEmpty(object)) {
            MessageHandler.getInstance().showInfo("");
        }
    }

    public String getSeed() {
        try {
            Map SeedProps = PasswordUtils.loadSeedForMigration(this.selectedPath + File.separator + "lib" + File.separator + "seed.properties");
            return (String)SeedProps.get("seed");
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    public String showSuffix() {
        return this.getCategory().isMultiLevel() && !Arrays.asList(Category.SOLR, Category.JVM, Category.SECURITY).contains((Object)this.getCategory()) ? "(s)" : " Settings";
    }
}

