/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.json.JsonUtil;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposedSetting {
    private static Logger logger = LoggerFactory.getLogger(ProposedSetting.class);
    private static Map<String, String> userSettingMap;
    private static Map<Category, Map<String, String>> aggregatedMap;
    private static Map<Category, Map<String, String>> aggregatedReverseMap;
    private static ProposedSetting instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProposedSetting getInstance() {
        if (instance != null) return instance;
        Class<ProposedSetting> clazz = ProposedSetting.class;
        synchronized (ProposedSetting.class) {
            instance = new ProposedSetting(Util.getConfigHome());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ProposedSetting(String jarPath) {
        ProposedSetting.readProposedSettings(jarPath);
        userSettingMap.forEach((settingPath, userSetting) -> {
            String[] settingSplit = settingPath.split("\\.");
            if (!Util.isSettingValid(settingSplit[0])) {
                logger.error(Messages.getString("invalidSettingCategory") + ": " + settingSplit[0]);
                return;
            }
            Category settingClass = Category.of(settingSplit[0]);
            String actualSetting = this.getActualSetting(settingSplit, settingClass, (String)settingPath);
            Map<String, String> map = aggregatedMap.get((Object)settingClass);
            Map<String, String> reverseMap = aggregatedReverseMap.get((Object)settingClass);
            if (Objects.isNull(map)) {
                map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                reverseMap = new HashMap<String, String>();
                aggregatedMap.put(settingClass, map);
                aggregatedReverseMap.put(settingClass, reverseMap);
            }
            map.put((String)userSetting, actualSetting);
            reverseMap.put(actualSetting, (String)userSetting);
        });
    }

    public String getActualSetting(String[] settingSplit, Category category, String settingPath) {
        Object actualSetting;
        if (category == Category.DOCUMENT && settingPath.contains("localhost")) {
            actualSetting = settingSplit[settingSplit.length - 1];
            actualSetting = "localhost." + (String)actualSetting;
        } else {
            actualSetting = EnumSet.of(Category.METRIC, Category.WATCH, Category.JVM, Category.SANDBOX, Category.SECURITY).contains((Object)category) ? this.getActualMetricWatchSetting(settingSplit) : settingSplit[settingSplit.length - 1];
        }
        return actualSetting;
    }

    private static void readProposedSettings(String jarPath) {
        try {
            File jsonFile = new File(jarPath + File.separator + "proposedSettings.json");
            userSettingMap = (HashMap)JsonUtil.getJsonObjectMapper().readValue(jsonFile, Map.class);
        }
        catch (Exception e1) {
            MessageHandler.getInstance().showError(Messages.getString("errorReadingSettingFile"));
            System.exit(0);
        }
    }

    public String getActualSetting(Category settingClass, String userSetting) {
        userSetting = userSetting.toLowerCase();
        if (settingClass == Category.MAPPING) {
            return userSetting;
        }
        return aggregatedMap.containsKey((Object)settingClass) ? aggregatedMap.get((Object)settingClass).get(userSetting) : null;
    }

    public String getUserDefinedValue(Category settingClass, String actualSetting) {
        if (settingClass == Category.MAPPING) {
            return actualSetting;
        }
        return aggregatedReverseMap.containsKey((Object)settingClass) ? aggregatedReverseMap.get((Object)settingClass).get(actualSetting) : null;
    }

    private String getActualMetricWatchSetting(String[] userSettingSplit) {
        Object userSettingKey = userSettingSplit[1];
        for (int i = 2; i < userSettingSplit.length; ++i) {
            userSettingKey = (String)userSettingKey + "." + userSettingSplit[i];
        }
        return userSettingKey;
    }

    public Map<String, String> getCategoryProposedSettingMap(Category category) {
        return aggregatedReverseMap.get((Object)category);
    }

    static {
        aggregatedMap = new HashMap<Category, Map<String, String>>();
        aggregatedReverseMap = new HashMap<Category, Map<String, String>>();
    }
}

