/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.CommandHelpRenderer;
import com.adobe.cfsetup.base.DeleteSupportedSettings;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import picocli.CommandLine;

@CommandLine.Command(name="delete", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class DeleteCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="2..*", hidden=true)
    public List<String> delete;
    @CommandLine.Parameters(index="0", hidden=true)
    private Category category;
    private String name;
    private List<String> subServices;
    private Map<String, List> keyValueMap;

    public Integer call() {
        AbstractCommand.commandName = CommandName.DELETE;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        int startIdx;
        this.subServices = new ArrayList<String>();
        this.keyValueMap = new HashMap<String, List>();
        boolean error = false;
        String service = this.delete.get(1);
        if (this.category == Category.SECURITY && service.contains("=")) {
            service = null;
        }
        String executionPath = null;
        int lastIndex = this.delete.size() - 1;
        String lastArg = this.delete.get(this.delete.size() - 1);
        if (!RegisterInstanceImpl.getInstance().isAlias(lastArg) && !Util.validCFHome(new File(lastArg))) {
            String instanceHome = this.getExecutionPathForLambda();
            if (instanceHome != null) {
                executionPath = instanceHome;
                --lastIndex;
            }
        } else {
            executionPath = this.delete.get(this.delete.size() - 1);
            --lastIndex;
        }
        if (executionPath != null && executionPath.contains("=")) {
            executionPath = null;
            lastIndex = this.delete.size() - 1;
        }
        for (int i = startIdx = this.category == Category.SECURITY && service == null ? 1 : 2; i <= lastIndex; ++i) {
            String s = this.delete.get(i);
            String[] settingPair = s.split("=");
            if (settingPair.length < 2 && this.category != Category.USER && this.category != Category.SANDBOX && this.category != Category.LDAPCONFIG && this.category != Category.SAMLCONFIG) {
                MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
                MessageHandler.getInstance().showError(CommandHelpRenderer.getAddHelpMessage(this.category));
                throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
            }
            String settingKey = settingPair[0];
            String settingValue = settingPair.length >= 2 ? Util.trimQuotes(s.substring(settingKey.length() + 1)) : "";
            String actualSetting = ProposedSetting.getInstance().getActualSetting(this.category, settingKey);
            if (actualSetting == null) {
                MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", settingKey, this.category.name()));
                error = true;
            }
            if (this.category == Category.SOLR && !"name".equalsIgnoreCase(actualSetting)) {
                MessageHandler.getInstance().showError(Messages.getString("deleteSubCategoryError", settingKey));
                error = true;
            }
            if (this.category != Category.SOLR && !SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                MessageHandler.getInstance().showError(Messages.getString(""));
                error = true;
            }
            if (!error) {
                Util.parseUserList(this.keyValueMap, actualSetting, settingValue);
            }
            if (!error) continue;
            throw new CFSetupException("Error while parsing");
        }
        return CommandInfo.builder().category(this.category).executionPath(executionPath).service(service).build();
    }

    @Override
    public boolean validateCommand() {
        boolean isServicePresent;
        if (!super.isCategoryAllowed(this.category)) {
            MessageHandler.getInstance().showError(Messages.getString("disabledForServerless"));
            return false;
        }
        if (!Util.validateExecutionPath(this.getExecutionFile())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            return false;
        }
        if (Objects.isNull(this.getGenericSetting())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            throw new CFSetupException(Messages.getString("invalidInstance"));
        }
        if (!(this.getGenericSetting() instanceof DeleteSupportedSettings)) {
            MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
            throw new CFSetupException(Messages.getString("operationNotSupported2", this.category.name().toLowerCase()));
        }
        Map<String, Object> map = this.getGenericSetting().getMap();
        boolean bl = isServicePresent = Category.JVM == this.category || Category.SECURITY == this.category || Category.LDAPCONFIG == this.category || Category.SAMLCONFIG == this.category || Category.CLIENTVARIABLE == this.category || this.category == Category.CUSTOMTAG && map.entrySet().stream().anyMatch(e -> ((String)e.getValue()).equalsIgnoreCase(this.getCommandInfo().getService())) || this.category == Category.SANDBOX && Util.getSandboxMap(map, this.getCommandInfo().getService()) != null || map.containsKey(this.getCommandInfo().getService());
        if (!isServicePresent) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", this.getCommandInfo().getService(), this.category.name()));
            return false;
        }
        if (MapUtils.isNotEmpty(this.keyValueMap)) {
            HashMap<String, Object> kvMap = new HashMap<String, Object>();
            for (Map.Entry<String, List> entry : this.keyValueMap.entrySet()) {
                String k = entry.getKey();
                List v = entry.getValue();
                if (v.size() == 1 && v.contains("")) continue;
                kvMap.put(k, v);
            }
            if (this.category != Category.SOLR) {
                Optional<Map<String, Object>> optionalMap = SettingValidation.getInstance().validateCommand(this.category, kvMap);
                if (optionalMap.isPresent()) {
                    kvMap = new HashMap<String, Object>(optionalMap.get());
                } else {
                    return false;
                }
            }
            for (Map.Entry<String, List> entry : this.keyValueMap.entrySet()) {
                if (!kvMap.containsKey(entry.getKey())) continue;
                this.keyValueMap.put(entry.getKey(), (List)kvMap.get(entry.getKey()));
            }
        }
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        boolean status = ((DeleteSupportedSettings)((Object)this.getGenericSetting())).deleteService(this.keyValueMap, this.getCommandInfo().getService());
        if (status) {
            MessageHandler.getInstance().showGreenAndBold(Messages.getString("deleteSuccess"));
            return ExitStatus.SUCCESS;
        }
        MessageHandler.getInstance().showError(Messages.getString("deleteFail"));
        return ExitStatus.FAIL;
    }

    @Override
    public void reset() {
        super.reset();
        this.name = null;
        this.category = null;
        this.delete = null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSubServices() {
        return this.subServices;
    }

    public void setCategory(Category category) {
        this.category = category;
    }
}

