/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.SettingFactory;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="deselect", descriptionHeading="%nDescription: ", customSynopsis={"deselect"}, synopsisHeading="Usage Pattern:%n")
public class DeselectCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(DeselectCommand.class);
    public static final String DESELECT_COMMAND = "deselect";
    @CommandLine.Parameters(paramLabel="", arity="0", hidden=true)
    public boolean deselect;

    public Integer call() {
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    private boolean deselectInstance() {
        RegisterInstanceImpl regImpl = RegisterInstanceImpl.getInstance();
        String instanceHome = regImpl.getSelectedInstPath();
        if (instanceHome != null) {
            try {
                SettingFactory.factories.clear();
                regImpl.deselectInstance();
                return true;
            }
            catch (Exception e) {
                logger.error("Error delecting alias", (Throwable)e);
                return false;
            }
        }
        MessageHandler.getInstance().showWarning(Messages.getString("DESELECT.noAliasWasSelected"));
        return true;
    }

    @Override
    public CommandInfo parseCommand() {
        return CommandInfo.builder().build();
    }

    @Override
    public boolean validateCommand() {
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        boolean status = this.deselectInstance();
        return status ? ExitStatus.SUCCESS : ExitStatus.FAIL;
    }
}

