/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.EntryPoint;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.base.SettingsDictionary;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class ExportCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(ExportCommand.class);
    @CommandLine.Parameters(paramLabel="", arity="2..3", hidden=true)
    List<String> export;
    @CommandLine.Option(names={"-p", "-P"}, description={"provides passphrase to encrypt sensitive information"})
    String passphrase;
    private Set<Category> categories;
    private String jsonFile;
    private boolean exportAll = false;
    public static Set<Category> exportBlackList = new HashSet<Category>(Arrays.asList(Category.JVM, Category.SERVER));

    public Integer call() {
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        String jsonFile;
        String settings = this.export.get(0);
        List<String> categoriesList = Arrays.asList(settings.split(","));
        String instancePath = this.export.get(this.export.size() - 1);
        if (instancePath.endsWith(".json")) {
            jsonFile = instancePath;
            instancePath = null;
        } else {
            jsonFile = this.export.get(this.export.size() - 2);
        }
        if (instancePath == null) {
            instancePath = this.getExecutionPathForLambda(this.export);
        }
        this.categories = new HashSet<Category>();
        categoriesList.forEach(category -> {
            if ("all".equalsIgnoreCase((String)category)) {
                this.exportAll = true;
            } else if (!exportBlackList.contains((Object)Category.of(category))) {
                this.categories.add(Category.of(category));
            } else {
                MessageHandler.getInstance().showError(Messages.getString("exportAndImportNotAllowedFor", category));
            }
        });
        this.jsonFile = jsonFile;
        return CommandInfo.builder().executionPath(instancePath).build();
    }

    @Override
    public boolean validateCommand() {
        boolean isValid = ExportCommand.checkJsonExt(this.jsonFile);
        if (!isValid) {
            return false;
        }
        boolean bl = isValid = Util.validateExecutionPath(this.getExecutionFile()) && !this.getExecutionFile().getName().endsWith(".json");
        if (!isValid) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
        }
        if (!this.exportAll && CollectionUtils.isEmpty(this.categories)) {
            return false;
        }
        if (isValid && Objects.nonNull(this.passphrase) && !(isValid = Util.isValidPassprase(this.passphrase))) {
            MessageHandler.getInstance().showError(Messages.getString("invalidPassphrase"));
        }
        return isValid;
    }

    @Override
    public ExitStatus runCommand() {
        AbstractCommand.commandName = CommandName.EXPORT;
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        boolean isEncryptionRequired = false;
        if (this.exportAll) {
            this.categories = new HashSet<Category>(SettingsDictionary.listSupportedCategories(this.getExecutionFile().getAbsolutePath()));
            if (isLambda) {
                this.categories = new HashSet<Category>(Arrays.asList(Category.getValues()));
            }
            this.categories.removeAll(exportBlackList);
        }
        for (Category category : this.categories) {
            GenericSetting genericSetting;
            Map settingMap;
            if (Util.isCategoryDisabled(this.getExecutionFile().getAbsolutePath(), category.name()) || MapUtils.isEmpty(settingMap = (genericSetting = SettingInstanceProvider.getInstance().getCategoryInstance(this.getExecutionFile(), category, this.isUseCachedSetting())).getMap())) continue;
            if (EnumSet.of(Category.RUNTIME).contains((Object)category)) {
                if (genericSetting instanceof MultilevelSetting) {
                    settingMap = ExportCommand.processNestedMapForJson(category.name().toLowerCase(), settingMap);
                } else {
                    settingMap = this.processMapForJson(settingMap);
                    MessageHandler.getInstance().showInfo(Messages.getString("exportingCategory", category.name()));
                }
            } else {
                boolean result;
                if (EnumSet.of(Category.CLIENTVARIABLE).contains((Object)category) && (result = settingMap.entrySet().stream().filter(entry -> ((Map.Entry)entry).getValue() instanceof Map).map(entry -> ((Map.Entry)entry).getValue()).filter(clientStoreMap -> ((Map)clientStoreMap).containsKey("type") && ((String)((Map)clientStoreMap).get("type")).equalsIgnoreCase("JDBC")).findFirst().isPresent())) {
                    MessageHandler.getInstance().showWarning(Messages.getString("CLIENTVARIABLE.export.warning"));
                }
                MessageHandler.getInstance().showInfo(Messages.getString("exportingCategory", category.name()));
            }
            isEncryptionRequired = isEncryptionRequired || !SettingValidation.getInstance().getEncryptedFields(genericSetting.getCategory()).isEmpty();
            jsonMap.put((String)((Object)category), settingMap);
        }
        if (isEncryptionRequired) {
            try {
                Map seedProps = PasswordUtils.loadSeedForMigration(this.getExecutionFile() + File.separator + "lib" + File.separator + "seed.properties");
                HashMap<String, Object> settingMap = new HashMap<String, Object>();
                settingMap.put("seed", seedProps.get("seed"));
                settingMap.put("algorithm", seedProps.get("algorithm"));
                String passphrase = StringUtils.isEmpty((CharSequence)this.passphrase) ? Util.getPassphrase() : this.passphrase;
                jsonMap.put("seedInfo", Util.encryptMap(passphrase, settingMap));
            }
            catch (ServiceException e) {
                MessageHandler.getInstance().showError(Messages.getString("errorLoadingSeed"));
                MessageHandler.getInstance().showError(Messages.getString("errorExport", e.getLocalizedMessage()));
                return ExitStatus.FAIL;
            }
            catch (IOException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                MessageHandler.getInstance().showError(Messages.getString("errorExport", e.getLocalizedMessage()));
                return ExitStatus.FAIL;
            }
            catch (CFSetupException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                MessageHandler.getInstance().showError(e.getLocalizedMessage());
                return ExitStatus.FAIL;
            }
        }
        if (!this.exportToJson(jsonMap, new File(this.jsonFile))) {
            MessageHandler.getInstance().showError(Messages.getString("errorExport1"));
            return ExitStatus.FAIL;
        }
        MessageHandler.getInstance().showGreenAndBold(Messages.getString("exportSuccess"), true);
        if (jsonMap.containsKey("seedInfo")) {
            MessageHandler.getInstance().showWarning(Messages.getString("exportWarning", this.jsonFile));
        }
        return ExitStatus.SUCCESS;
    }

    private boolean exportToJson(Map<String, Object> configMap, File jsonFile) {
        try {
            if (EntryPoint.isNonInteractive && jsonFile.exists()) {
                Files.delete(jsonFile.toPath());
            } else if (jsonFile.exists()) {
                String line = EntryPoint.getCommand().getReader().readLine(Messages.getString("replaceFilePermission"));
                if (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes")) {
                    Files.delete(jsonFile.toPath());
                } else {
                    throw new CFSetupException(Messages.getString("userInterruption"));
                }
            }
            if (!jsonFile.createNewFile()) {
                MessageHandler.getInstance().showError("Failed to create new json file");
                return false;
            }
        }
        catch (IOException e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error("Failed to create/delete json file", (Throwable)e);
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(jsonFile);
            Gson gson = new Gson();
            gson.toJson(configMap, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkJsonExt(String jsonFile) {
        if (jsonFile != null && !jsonFile.equals("")) {
            if (jsonFile != null && !jsonFile.endsWith(".json")) {
                MessageHandler.getInstance().showError(Messages.getString("invalidJsonExt"));
                return false;
            }
            String[] jsonFileHasName = jsonFile.split("\\.");
            if (jsonFileHasName[0].length() <= 0) {
                MessageHandler.getInstance().showError(Messages.getString("invalidJsonExt"));
                return false;
            }
        }
        return true;
    }

    private Map fixRegexQuotes(Map settingMap) {
        String pattern = (String)settingMap.get("pattern");
        pattern = ExportCommand.escapeForJava(pattern, false);
        settingMap.put("pattern", pattern);
        return settingMap;
    }

    public static String escapeForJava(String value, boolean quote) {
        StringBuilder builder = new StringBuilder();
        if (quote) {
            builder.append("\"");
        }
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                builder.append("\\'");
                continue;
            }
            if (c == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\t') {
                builder.append("\\t");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                builder.append(String.format("\\u%04x", c));
                continue;
            }
            builder.append(c);
        }
        if (quote) {
            builder.append("\"");
        }
        return builder.toString();
    }

    private Map processMapForJson(Map<String, Object> settingMap) {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        for (String key : settingMap.keySet()) {
            Object obj = settingMap.get(key);
            String val = String.valueOf(obj);
            tmpMap.put(key.toString(), val);
        }
        return tmpMap;
    }

    private static Map processNestedMapForJson(String setting, Map<String, Object> settingMap) {
        HashMap<String, String> tmpMap3 = new HashMap<String, String>();
        HashMap<String, Object> tmpMap2 = new HashMap<String, Object>();
        Category neoSetting = Category.of(setting);
        HashMap<String, Object> tmpMap = setting.equals("scheduletask") ? new HashMap<String, Object>() : (setting.equals("datasource") ? new HashMap() : (neoSetting == Category.CLOUDCREDENTIAL ? new HashMap() : new HashMap()));
        for (String key : settingMap.keySet()) {
            Object val;
            HashMap<String, Object> tmpMap1 = new HashMap<String, Object>();
            if (key != null) {
                MessageHandler.getInstance().showError(Messages.getString("export") + " " + setting + " " + key);
            }
            if (key == null) continue;
            Object data = settingMap.get(key);
            if (data instanceof MapObject) {
                val = String.valueOf(((MapObject)data).getValue());
                if (((String)val).endsWith("\\")) {
                    val = ((String)val).concat("hdkshfkw");
                }
                tmpMap.put(key, val);
                continue;
            }
            if (data instanceof Map) {
                for (String attrib1 : ((Map)data).keySet()) {
                    Object data1 = ((Map)data).get(attrib1);
                    if (data1 instanceof MapObject) {
                        tmpMap1.put(attrib1, ((MapObject)data1).getValue());
                    } else if (data1 instanceof String) {
                        tmpMap1.put(attrib1, data1);
                    } else if (data1 instanceof Map) {
                        for (String attrib2 : ((Map)data1).keySet()) {
                            Object data2 = ((Map)data1).get(attrib2);
                            if (data2 instanceof MapObject) {
                                tmpMap2.put(attrib2, ((MapObject)data2).getValue());
                                continue;
                            }
                            if (data1 instanceof String) {
                                tmpMap1.put(attrib1, data1);
                                continue;
                            }
                            for (String attrib3 : ((Map)data2).keySet()) {
                                Object data3 = ((Map)data2).get(attrib3);
                                if (!(data3 instanceof MapObject)) continue;
                                tmpMap3.put(attrib3, ((MapObject)data3).getValue());
                            }
                            tmpMap2.put(attrib2, tmpMap3);
                            tmpMap3 = new HashMap();
                        }
                        tmpMap1.put(attrib1, tmpMap2);
                        tmpMap2 = new HashMap();
                    } else {
                        tmpMap1.put(attrib1, data1);
                    }
                    tmpMap.put(key, tmpMap1);
                }
                continue;
            }
            if (data instanceof Collection) {
                tmpMap.put(key, data);
                continue;
            }
            val = String.valueOf(data);
            if (((String)val).endsWith("\\")) {
                val = ((String)val).concat("hdkshfkw");
            }
            tmpMap.put(key, val);
        }
        MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)setting) + " " + Messages.getString("exportSuccess"), true);
        return tmpMap;
    }

    @Override
    public void reset() {
        super.reset();
        this.passphrase = null;
        this.export = null;
        this.jsonFile = null;
        this.categories = null;
        this.exportAll = false;
    }
}

