/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.SettingFactory;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.CFVersions;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="select", descriptionHeading="%nDescription: ", customSynopsis={"select <aliasname>"}, synopsisHeading="Usage Pattern:%n")
public class SelectCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(SelectCommand.class);
    public static final String SELECT_COMMAND = "select";
    @CommandLine.Parameters(paramLabel="", arity="1", hidden=true)
    public String select;

    public Integer call() {
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    private boolean selectInstance(String alias) {
        RegisterInstanceImpl regImpl = RegisterInstanceImpl.getInstance();
        String instanceHome = regImpl.getInstancePath(alias);
        if (instanceHome != null) {
            String factoryKey = RegisterInstanceImpl.getAliasFromMap(alias);
            String factoryKeyV2 = instanceHome;
            try {
                SettingFactory settingFactory = new SettingFactory(instanceHome);
                SettingFactory.factories.put(factoryKey, settingFactory);
                SettingFactory.factories.put(factoryKeyV2, settingFactory);
                regImpl.selectInstance(alias, instanceHome);
            }
            catch (Exception e) {
                MessageHandler.getInstance().showError(Messages.getString("errorInitInstance"));
                MessageHandler.getInstance().showInfo(Messages.getString("validAliases", SelectAliasList.getCommaSeparatedAliases()));
                logger.error(Messages.getString("errorInitInstance"), (Throwable)e);
                regImpl.deselectInstance();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public CommandInfo parseCommand() {
        return CommandInfo.builder().build();
    }

    @Override
    public boolean validateCommand() {
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        return this.selectInstance(this.select) ? ExitStatus.SUCCESS : ExitStatus.FAIL;
    }

    public static class SelectAliasList
    extends ArrayList<String> {
        private static List<String> aliasList = new LinkedList<String>();

        public static String getCommaSeparatedAliases() {
            return StringUtils.join(aliasList, (String)",");
        }

        public SelectAliasList() {
            this.addAll(aliasList);
        }

        static {
            RegisterInstanceImpl.allInstancesCFHome.keySet().forEach((? super T aliasName) -> {
                if (aliasName.endsWith(CFVersions.CF2023.name())) {
                    String vName = CFVersions.CF2023.name();
                    String alias = aliasName.substring(0, aliasName.length() - vName.length());
                    aliasList.add(alias);
                } else if (aliasName.endsWith(CFVersions.CF2021.name())) {
                    String vName = CFVersions.CF2021.name();
                    String alias = aliasName.substring(0, aliasName.length() - vName.length());
                    aliasList.add(alias);
                } else if (aliasName.endsWith(CFVersions.CF2018.name())) {
                    String vName = CFVersions.CF2018.name();
                    String alias = aliasName.substring(0, aliasName.length() - vName.length());
                    aliasList.add(alias);
                } else if (aliasName.endsWith(CFVersions.CF2016.name())) {
                    String vName = CFVersions.CF2016.name();
                    String alias = aliasName.substring(0, aliasName.length() - vName.length());
                    aliasList.add(alias);
                }
            });
        }
    }
}

