/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.CommandLogger;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.DeleteSupportedSettings;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.commands.service.SetCommandService;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.json.JsonUtil;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="set", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class SetCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="2..*", hidden=true)
    private List<String> set = new ArrayList<String>();
    private Category category;
    private int startIndex;
    private int endIndex;
    private Map<String, Object> keyValueMap = Collections.EMPTY_MAP;
    private Map<String, Object> userInputMap = new HashMap<String, Object>();
    private static final Logger logger = LoggerFactory.getLogger(SetCommand.class);

    public Integer call() {
        AbstractCommand.commandName = CommandName.SET;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        if (this.set.contains("=")) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingKeyPair"));
            throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
        }
        String cat = this.set.get(0);
        this.category = Category.of(cat);
        CommandInfo commandInfo = new CommandInfo();
        String lastCliArg = this.set.get(this.set.size() - 1);
        String executionPath = lastCliArg.contains("=") ? this.getExecutionPathForLambda(this.set) : lastCliArg;
        String service = this.set.get(1).contains("=") ? null : this.set.get(1);
        this.startIndex = service == null ? 1 : 2;
        int n = this.endIndex = executionPath == null ? this.set.size() : this.set.size() - 1;
        if (this.startIndex >= this.endIndex) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingKeyPair"));
            throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        boolean error = false;
        Set<String> toBeEncryptedFields = SettingValidation.getInstance().getEncryptedFields(this.category);
        for (String s : this.set.subList(this.startIndex, this.endIndex)) {
            String[] settingPair = s.split("=");
            if (settingPair.length < 2) {
                MessageHandler.getInstance().showError(Messages.getString("invalidSettingKeyPair"));
                throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
            }
            String settingKey = settingPair[0];
            String settingValue = Util.trimQuotes(s.substring(settingKey.length() + 1));
            String actualSetting = ProposedSetting.getInstance().getActualSetting(this.category, settingKey);
            if (actualSetting == null) {
                if (this.category != Category.SERVER || "other".equalsIgnoreCase(service)) {
                    MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", settingKey, this.category.name()));
                    error = true;
                    continue;
                }
                actualSetting = settingKey;
            }
            if (toBeEncryptedFields.contains(actualSetting) || this.category == Category.SECURITY) {
                CommandLogger.encrypt(settingKey, settingValue);
            }
            if (keyValueMap.get(actualSetting) != null && !SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                MessageHandler.getInstance().showError(Messages.getString("duplicateSettingkey", settingKey));
                error = true;
            }
            if (error) continue;
            if (SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                Util.parseUserList(keyValueMap, actualSetting, settingValue);
                continue;
            }
            keyValueMap.put(actualSetting, settingValue);
        }
        if (error) {
            throw new CFSetupException("Error while parsing");
        }
        this.keyValueMap = Collections.unmodifiableMap(keyValueMap);
        return CommandInfo.builder().category(this.category).executionPath(executionPath).service(service).build();
    }

    @Override
    public boolean validateCommand() {
        if (!super.isCategoryAllowed(this.category)) {
            MessageHandler.getInstance().showError(Messages.getString("disabledForServerless"));
            return false;
        }
        if (!Util.validateExecutionPath(this.getExecutionFile())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            return false;
        }
        if (Objects.isNull(this.getGenericSetting())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            throw new CFSetupException(Messages.getString("invalidInstance"));
        }
        List<Category> categoryWithSpecialService = Arrays.asList(Category.SOLR, Category.JVM, Category.SCHEDULETASK, Category.SECURITY, Category.LDAPCONFIG, Category.SAMLCONFIG);
        if (!categoryWithSpecialService.contains((Object)this.category) && (this.getGenericSetting() instanceof MultilevelSetting || this.getGenericSetting() instanceof DeleteSupportedSettings) && !SettingValidation.getInstance().getServicedependentKeys(this.category, this.keyValueMap.keySet()).isEmpty()) {
            if (StringUtils.isBlank((CharSequence)this.getCommandInfo().getService())) {
                MessageHandler.getInstance().showError(Messages.getString("SET.blankServiceName", this.category.name()));
                return false;
            }
            if (!this.getGenericSetting().getMap().containsKey(this.getCommandInfo().getService())) {
                MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", this.getCommandInfo().getService(), this.category.name()));
                return false;
            }
        }
        HashMap<String, Object> updatedKeyValueMap = new HashMap<String, Object>();
        String service = this.getCommandInfo().getService();
        if (!SettingValidation.getInstance().validateServiceName(this.getGenericSetting(), service, this.keyValueMap.keySet())) {
            return false;
        }
        Map currentMap = service != null ? (Map)this.getGenericSetting().getMap().get(service) : this.getGenericSetting().getMap();
        SettingValidation.getInstance().dependencyValidation(this.category, this.keyValueMap, currentMap);
        HashSet<String> failedSettings = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.keyValueMap.entrySet()) {
            String actualSetting = entry.getKey();
            Object value = entry.getValue();
            if (SettingValidation.getInstance().getValidationDetail(this.category, actualSetting).isList()) {
                List list = (List)value;
                for (Object v : list) {
                    String val = (String)v;
                    Optional<Object> updatedValue = SettingValidation.getInstance().validateAndUpdateValue(this.category, actualSetting, String.valueOf(val));
                    if (!updatedValue.isPresent()) {
                        failedSettings.add(ProposedSetting.getInstance().getUserDefinedValue(this.category, actualSetting));
                        continue;
                    }
                    Util.addListToMap(updatedKeyValueMap, actualSetting, updatedValue.get());
                }
            } else {
                Optional<Object> updatedValue = SettingValidation.getInstance().validateAndUpdateValue(this.category, actualSetting, String.valueOf(value));
                if (!updatedValue.isPresent()) {
                    failedSettings.add(ProposedSetting.getInstance().getUserDefinedValue(this.category, actualSetting));
                } else {
                    updatedKeyValueMap.put(actualSetting, updatedValue.get());
                }
            }
            if (SettingValidation.getInstance().validateDuplicateServiceName(this.getGenericSetting(), actualSetting, String.valueOf(value), service)) continue;
            failedSettings.add(ProposedSetting.getInstance().getUserDefinedValue(this.category, actualSetting));
        }
        if (!failedSettings.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("validationFailed", this.category.name(), StringUtils.join(failedSettings, (String)"\n")));
            logger.error(Messages.getString("validationFailed", this.category.name(), StringUtils.join(failedSettings, (String)"")));
            return false;
        }
        this.keyValueMap = Collections.unmodifiableMap(updatedKeyValueMap);
        return this.getGenericSetting().validate(updatedKeyValueMap, this.getCommandInfo().getService());
    }

    @Override
    public ExitStatus runCommand() {
        CommandInfo commandInfo = this.getCommandInfo();
        Map<String, Boolean> statuses = SetCommandService.INSTANCE.updateSettings(commandInfo.getService(), this.keyValueMap, this.getGenericSetting(), this.getExecutionFile());
        SetCommand.printStatusMessage(statuses);
        boolean isFail = statuses.values().stream().noneMatch(Boolean::booleanValue);
        return isFail ? ExitStatus.FAIL : ExitStatus.SUCCESS;
    }

    private static void printStatusMessage(Map<String, Boolean> statuses) {
        String successKeys = statuses.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.joining(", "));
        String failedKeys = statuses.entrySet().stream().filter(map -> (Boolean)map.getValue() == false).map(Map.Entry::getKey).collect(Collectors.joining(", "));
        if (!StringUtils.isEmpty((CharSequence)successKeys)) {
            MessageHandler.getInstance().showGreenAndBold("Settings [" + successKeys + "] set successfully", true);
        }
        if (!StringUtils.isEmpty((CharSequence)failedKeys)) {
            MessageHandler.getInstance().showError("Failed to set the setting [" + failedKeys + "]");
        }
    }

    private static Map<String, Boolean> setInJson(String settingClass, List<String> settings, String jsonFile) {
        if (!new File(jsonFile).isFile()) {
            MessageHandler.getInstance().showError("Json file does not exists");
            return SetCommand.getAllFailedMap(settings);
        }
        if (settings == null) {
            return SetCommand.getAllFailedMap(settings);
        }
        settings = settings.stream().map(setting -> ProposedSetting.getInstance().getActualSetting(Category.of(settingClass), (String)setting)).collect(Collectors.toList());
        return JsonUtil.setAttributes(settingClass, jsonFile, settings);
    }

    private static Map<String, Boolean> getAllFailedMap(List<String> settings) {
        HashMap<String, Boolean> statuses = new HashMap<String, Boolean>();
        settings.stream().forEach(s -> statuses.put(s.split("=")[0], false));
        return statuses;
    }

    @Override
    public void reset() {
        this.userInputMap = new HashMap<String, Object>();
        this.keyValueMap = Collections.EMPTY_MAP;
        this.set = new ArrayList<String>();
        this.category = null;
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public void setSetArgs(List<String> set) {
        this.set = set;
    }
}

