/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands.service;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AddCommandService {
    public static final AddCommandService INSTANCE = new AddCommandService();

    private AddCommandService() {
    }

    public boolean updateService(MultilevelSetting multilevelSetting, Map<String, Object> keyValueMap, String service, File executionFile) {
        Map seedProps;
        HashMap<String, Object> encryptedMap = new HashMap<String, Object>(keyValueMap);
        try {
            seedProps = PasswordUtils.loadSeedForMigration(executionFile + File.separator + "lib" + File.separator + "seed.properties");
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorLoadingEncryptionProps"));
            return false;
        }
        String seed = (String)seedProps.get("seed");
        ((Set)Optional.ofNullable(SettingValidation.getInstance().getEncryptedFields(multilevelSetting.getCategory())).orElse(new HashSet())).forEach(toBeEncryptedKey -> {
            String inputValue;
            String string = inputValue = Objects.nonNull(keyValueMap.get(toBeEncryptedKey)) ? String.valueOf(keyValueMap.get(toBeEncryptedKey)) : "";
            if (StringUtils.isNotBlank((CharSequence)inputValue)) {
                String encryptedValue = PasswordUtils.encryptPassword(inputValue, seed);
                encryptedMap.put((String)toBeEncryptedKey, encryptedValue);
            }
        });
        return multilevelSetting.addService(encryptedMap, service);
    }
}

