/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands.service;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.service.AddCommandService;
import com.adobe.cfsetup.commands.service.SetCommandService;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCommandService {
    private static final Logger logger = LoggerFactory.getLogger(ImportCommandService.class);
    public static final ImportCommandService INSTANCE = new ImportCommandService();

    private ImportCommandService() {
    }

    public boolean importService(String service, Map<String, Object> keyValueMap, MultilevelSetting multilevelSetting, File executionFile, Map<String, String> seedInfo) {
        HashMap<String, Object> decryptedMap = new HashMap<String, Object>(keyValueMap);
        if (multilevelSetting.getCategory() != Category.SOLR || !"language".equalsIgnoreCase(service)) {
            boolean isReqValuePresent = SettingValidation.getInstance().validateRequiredFields(multilevelSetting.getCategory(), keyValueMap);
            if (!isReqValuePresent) {
                return false;
            }
            Optional<Map<String, Object>> optionalMap = SettingValidation.getInstance().validateCommand(multilevelSetting.getCategory(), keyValueMap);
            if (!optionalMap.isPresent()) {
                return false;
            }
            HashMap<String, Object> validatedKeyValueMap = new HashMap<String, Object>(optionalMap.get());
            decryptedMap = new HashMap<String, Object>(validatedKeyValueMap);
            ImportCommandService.sanitizeCFIDEPath(service, multilevelSetting, executionFile, decryptedMap);
            for (String toBeEncryptedKey : SettingValidation.getInstance().getEncryptedFields(multilevelSetting.getCategory())) {
                String inputValue = Objects.nonNull(validatedKeyValueMap.get(toBeEncryptedKey)) ? String.valueOf(validatedKeyValueMap.get(toBeEncryptedKey)) : "";
                if (!StringUtils.isNotBlank((CharSequence)inputValue)) continue;
                String decryptedValue = PasswordUtils.decryptPassword(inputValue, seedInfo.get("seed"), seedInfo.get("algorithm"));
                decryptedMap.put(toBeEncryptedKey, decryptedValue);
            }
            String invalidKeys = keyValueMap.entrySet().stream().filter(v -> ProposedSetting.getInstance().getUserDefinedValue(multilevelSetting.getCategory(), (String)v.getKey()) == null).map(v -> (String)v.getKey()).collect(Collectors.joining(", "));
            if (StringUtils.isNotBlank((CharSequence)invalidKeys)) {
                MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", invalidKeys, multilevelSetting.getCategory().name()));
                return false;
            }
        }
        return AddCommandService.INSTANCE.updateService(multilevelSetting, decryptedMap, service, executionFile);
    }

    private static void sanitizeCFIDEPath(String service, MultilevelSetting multilevelSetting, File executionFile, Map<String, Object> decryptedMap) {
        if (multilevelSetting.getCategory() == Category.MAPPING && service.equalsIgnoreCase("/CFIDE") && decryptedMap.containsKey("virtual") && ((String)decryptedMap.get("virtual")).equalsIgnoreCase("/CFIDE")) {
            decryptedMap.put("physical", ImportCommandService.getCfidePath(executionFile));
        }
    }

    private static String getCfidePath(File executionFile) {
        String cfRoot = executionFile.getAbsolutePath();
        if (cfRoot.contains("WEB-INF")) {
            cfRoot = executionFile.getParentFile().getParent();
            return cfRoot + File.separator + "CFIDE";
        }
        return cfRoot + File.separator + "wwwroot" + File.separator + "CFIDE";
    }

    public boolean importSetting(String service, String key, Object value, GenericSetting genericSetting, File executionFIle, Map<String, String> seedInfo) {
        if (genericSetting.getCategory() == Category.SECURITY && key.equalsIgnoreCase("allowedAdminIPList")) {
            return SetCommandService.INSTANCE.updateSetting(service, key, value, genericSetting, executionFIle);
        }
        String stringValue = Objects.nonNull(value) ? String.valueOf(value) : null;
        String usersetting = ProposedSetting.getInstance().getUserDefinedValue(genericSetting.getCategory(), key);
        if (usersetting == null && genericSetting.getCategory() != Category.CUSTOMTAG) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingKey1", key, genericSetting.getCategory().name()));
            return false;
        }
        Optional<Object> updatedValue = SettingValidation.getInstance().validateAndUpdateValue(genericSetting.getCategory(), key, stringValue);
        if (!updatedValue.isPresent()) {
            if (genericSetting.getCategory() != Category.CLIENTVARIABLE || genericSetting.getCategory() == Category.CLIENTVARIABLE && !key.equalsIgnoreCase("default")) {
                MessageHandler.getInstance().showError(Messages.getString("validationSingleFailed", ProposedSetting.getInstance().getUserDefinedValue(genericSetting.getCategory(), key), genericSetting.getCategory().name()));
                logger.error(Messages.getString("validationSingleFailed", ProposedSetting.getInstance().getUserDefinedValue(genericSetting.getCategory(), key), genericSetting.getCategory().name()));
                return false;
            }
        } else {
            value = updatedValue.get();
        }
        Object decryptedValue = value;
        if (SettingValidation.getInstance().getEncryptedFields(genericSetting.getCategory()).contains(key)) {
            String inputValue;
            String string = inputValue = Objects.nonNull(value) ? String.valueOf(value) : "";
            if (StringUtils.isNotBlank((CharSequence)inputValue)) {
                decryptedValue = PasswordUtils.decryptPassword(inputValue, seedInfo.get("seed"), seedInfo.get("algorithm"));
            }
        }
        boolean status = SetCommandService.INSTANCE.updateSetting(service, key, decryptedValue, genericSetting, executionFIle);
        return status;
    }
}

