/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands.service;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SetCommandService {
    public static final SetCommandService INSTANCE = new SetCommandService();

    private SetCommandService() {
    }

    public Map<String, Boolean> updateSettings(String service, Map<String, Object> keyValueMap, GenericSetting providedeGenericSetting, File executionPath) {
        HashMap seedProps = new HashMap();
        HashMap<String, Boolean> statusMap = new HashMap<String, Boolean>();
        keyValueMap.forEach((settingKey, value) -> {
            String actualSettingKey;
            String key = settingKey;
            GenericSetting genericSetting = providedeGenericSetting;
            Pair<GenericSetting, String> genericSettingKeyPair = Util.getExternalDependency(genericSetting.getCategory(), key, executionPath);
            if (genericSettingKeyPair != null) {
                genericSetting = (GenericSetting)genericSettingKeyPair.getLeft();
                key = (String)genericSettingKeyPair.getRight();
            }
            Object encryptedValue = value;
            if (SettingValidation.getInstance().getEncryptedFields(genericSetting.getCategory()).contains(key)) {
                String userDefinedSetting = ProposedSetting.getInstance().getUserDefinedValue(genericSetting.getCategory(), key);
                if (seedProps.isEmpty()) {
                    try {
                        seedProps.putAll(this.getSeedProps(executionPath));
                    }
                    catch (ServiceException e) {
                        statusMap.put(userDefinedSetting, false);
                        return;
                    }
                }
                if (seedProps.containsKey("seed") && StringUtils.isNotBlank((CharSequence)String.valueOf(value))) {
                    encryptedValue = PasswordUtils.encryptPassword(String.valueOf(value), (String)seedProps.get("seed"));
                }
            }
            if ((actualSettingKey = ProposedSetting.getInstance().getUserDefinedValue(providedeGenericSetting.getCategory(), (String)settingKey)) != null) {
                statusMap.put(actualSettingKey, genericSetting.setSetting(key, encryptedValue, service));
            } else if (providedeGenericSetting.getCategory() == Category.SERVER && (service.equalsIgnoreCase("HTTP") || service.equalsIgnoreCase("AJP") || service.equalsIgnoreCase("HTTPS"))) {
                statusMap.put((String)settingKey, genericSetting.setSetting(key, encryptedValue, service));
            }
        });
        return statusMap;
    }

    boolean updateSetting(String service, String key, Object value, GenericSetting genericSetting, File executionPath) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        Map<String, Boolean> statuses = this.updateSettings(service, map, genericSetting, executionPath);
        return statuses.getOrDefault(ProposedSetting.getInstance().getUserDefinedValue(genericSetting.getCategory(), key), false);
    }

    private Map<String, String> getSeedProps(File executionPath) throws ServiceException {
        return PasswordUtils.loadSeedForMigration(executionPath.getAbsolutePath() + File.separator + "lib" + File.separator + "seed.properties");
    }
}

