/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.constants;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public enum Category {
    CLIENTVARIABLE("neo-clientstore.xml", true, false),
    CUSTOMTAG("neo-runtime.xml", true),
    COM("neo-comobjmap.xml", false, false),
    DEBUG("neo-debug.xml", false, false),
    DOCUMENT("neo-document.xml", false, false),
    DOTNET("neo-dotnet.xml", false, false),
    EVENTGATEWAYSETTING("neo-event.xml", false, false),
    CHART("neo-graphing.xml", false, false),
    LOGGING("neo-logging.xml", false, false),
    MAIL("neo-mail.xml"),
    MAPPING("neo-runtime.xml", true),
    METRIC("neo-metric.xml", false, false),
    RUNTIME("neo-runtime.xml"),
    CACHING("neo-runtime.xml"),
    WATCH("neo-watch.xml", false, false),
    WEBSOCKET("neo-websocket.xml", false, false),
    PROBECONFIG("neo-probe.xml", false, false),
    SECURITY("neo-security.xml", true, false),
    JVM("jvm.config", true, false),
    EVENTGATEWAYINSTANCE("neo-event.xml", true, false),
    SCHEDULETASK("neo-cron.xml", true, false),
    DATASOURCE("neo-datasource.xml", true),
    PDFSERVICE("neo-document.xml", true, false),
    EVENTGATEWAYTYPE("neo-event.xml", true, false),
    SOLR("neo-solr.xml", true, false),
    CLOUDCREDENTIAL("neo-cloudcredential.xml", true),
    CLOUDCONFIGURATION("neo-cloud-config.xml", true),
    SPCONFIGURATION("neo-saml.xml", true, false),
    IDPCONFIGURATION("neo-saml.xml", true, false),
    REST("neo-jaxrs.xml", true),
    PROBE("neo-probe.xml", true, false),
    WEBSERVICE("neo-xmlrpc.xml", true, false),
    SERVER("server.xml", true, false),
    NOSQL("neo-nosql-datasource.xml", true),
    MONITORING("neo-monitoring.xml", false, false),
    SANDBOX("neo-security.xml", true, false),
    USER("neo-security.xml", true, false),
    SAMLCONFIG("neo-security.xml"),
    LDAPCONFIG("neo-security.xml"),
    GRAPHQLCLIENTCONFIG("neo-graphql-config.xml", true, false),
    GRAPHQLSERVICECONFIG("pom.xml", true, false);

    private String fileName;
    private boolean isMultiLevel = false;
    private boolean isServerlessCompatible = true;

    public String getFileName() {
        return this.fileName;
    }

    public boolean isMultiLevel() {
        return this.isMultiLevel;
    }

    public boolean isServerlessCompatible() {
        return this.isServerlessCompatible;
    }

    private Category(String filename) {
        this.fileName = filename;
    }

    private Category(String filename, boolean isMultiLevel) {
        this.fileName = filename;
        this.isMultiLevel = isMultiLevel;
    }

    private Category(String filename, boolean isMultiLevel, boolean isServerlessCompatible) {
        this.fileName = filename;
        this.isMultiLevel = isMultiLevel;
        this.isServerlessCompatible = isServerlessCompatible;
    }

    public static Category[] getValues() {
        if (!AbstractCommand.isLambda) {
            return Category.values();
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        for (Category category : Category.values()) {
            if (!category.isServerlessCompatible()) continue;
            categories.add(category);
        }
        Category[] finalCategories = categories.toArray(new Category[0]);
        Arrays.sort((Object[])finalCategories);
        return finalCategories;
    }

    public static Category of(String value) {
        try {
            return Category.valueOf(Category.class, value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory1", value));
            throw new CFSetupException(Messages.getString("invalidSettingCategory1", value));
        }
    }

    public static Optional<Category> getCategory(String value) {
        try {
            return Optional.of(Category.valueOf(Category.class, value.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    public static class CategoryComparator
    implements Comparator<Category> {
        @Override
        public int compare(Category o1, Category o2) {
            return o1.name().compareTo(o2.name());
        }
    }
}

