/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.external;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.commands.SelectCommand;
import com.adobe.cfsetup.constants.CFVersions;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.external.RegisterInstance;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class RegisterInstanceImpl
implements RegisterInstance {
    private String alias;
    private String selectedInstPath;
    private static RegisterInstanceImpl instance = new RegisterInstanceImpl();
    public static Map<String, String> allInstancesCFHome = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public static RegisterInstanceImpl getInstance() {
        return instance;
    }

    private RegisterInstanceImpl() {
    }

    public static String getAliasFromMap(String alias) {
        for (CFVersions version : CFVersions.values()) {
            String aliasName = alias + version.name();
            if (!allInstancesCFHome.containsKey(aliasName)) continue;
            return aliasName;
        }
        return null;
    }

    public static String getInstanceLocationFromAlias(String alias) {
        for (CFVersions version : CFVersions.values()) {
            String aliasName = alias + version.name();
            if (!allInstancesCFHome.containsKey(aliasName)) continue;
            return allInstancesCFHome.get(aliasName);
        }
        return null;
    }

    @Override
    public String getSelectedInstanceCFHome(String alias) {
        return allInstancesCFHome.get(RegisterInstanceImpl.getAliasFromMap(alias));
    }

    @Override
    public String getInstancePath(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            this.selectedInstPath = null;
            this.alias = null;
            return null;
        }
        String alias_mapKey = RegisterInstanceImpl.getAliasFromMap(alias);
        if (alias_mapKey == null) {
            MessageHandler.getInstance().showError(Messages.getString("selectAliasFirst", alias));
            MessageHandler.getInstance().showInfo(Messages.getString("validAliases", SelectCommand.SelectAliasList.getCommaSeparatedAliases()));
            return null;
        }
        return allInstancesCFHome.get(alias_mapKey);
    }

    public boolean isAlias(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            this.selectedInstPath = null;
            this.alias = null;
            return false;
        }
        String alias_mapKey = RegisterInstanceImpl.getAliasFromMap(alias);
        if (alias_mapKey == null) {
            return false;
        }
        return allInstancesCFHome.get(alias_mapKey) != null;
    }

    @Override
    public String selectInstance(String alias, String instancePath) {
        this.selectedInstPath = instancePath;
        this.alias = alias;
        return this.selectedInstPath;
    }

    public void deselectInstance() {
        this.selectedInstPath = null;
        this.alias = null;
    }

    @Override
    public boolean registerInstance(String currentCFHome, String alias, boolean update) {
        boolean alreadyRegistered = false;
        String registeredInstanceAlias = null;
        String aliasKey = RegisterInstanceImpl.getAliasFromMap(alias);
        if (aliasKey != null && !update) {
            MessageHandler.getInstance().showInfo(Messages.getString("duplicateAlias", alias));
            return false;
        }
        for (String cfAlias : allInstancesCFHome.keySet()) {
            if (!allInstancesCFHome.get(cfAlias).equalsIgnoreCase(currentCFHome) || cfAlias.equalsIgnoreCase(aliasKey)) continue;
            alreadyRegistered = true;
            registeredInstanceAlias = cfAlias;
            registeredInstanceAlias = registeredInstanceAlias.substring(0, registeredInstanceAlias.length() - 6);
            break;
        }
        if (!alreadyRegistered) {
            if (update) {
                this.removeAliasFromMap(aliasKey);
            }
            CFVersions versionFromJar = this.getCFVersionFromJar(currentCFHome);
            allInstancesCFHome.put(alias + versionFromJar, currentCFHome);
            if (this.saveAliasToJson()) {
                if (!update) {
                    MessageHandler.getInstance().showGreenAndBold(Messages.getString("instanceRegisterSuccess"));
                } else {
                    MessageHandler.getInstance().showGreenAndBold(Messages.getString("aliasUpdateSuccess"));
                }
                return true;
            }
            return false;
        }
        MessageHandler.getInstance().showError(Messages.getString("alreadyRegisteredInstance") + registeredInstanceAlias + ".");
        return false;
    }

    @Override
    public boolean deleteAlias(String alias) {
        String aliasKey = RegisterInstanceImpl.getAliasFromMap(alias);
        if (aliasKey != null) {
            String cfHomePath = allInstancesCFHome.get(aliasKey);
            if (cfHomePath.equalsIgnoreCase(this.selectedInstPath)) {
                this.deselectInstance();
            }
            this.removeAliasFromMap(aliasKey);
        }
        if (this.saveAliasToJson()) {
            MessageHandler.getInstance().showGreenAndBold(Messages.getString("aliasDeleteSuccess"));
            return true;
        }
        return false;
    }

    private boolean saveAliasToJson() {
        String regFile = Util.getConfigHome() + File.separator + "registeredAlias.json";
        try {
            FileWriter file = new FileWriter(regFile);
            Gson gson = new Gson();
            gson.toJson(allInstancesCFHome, (Appendable)file);
            file.close();
        }
        catch (IOException e) {
            MessageHandler.getInstance().showError(Messages.getString("cannotWriteToFile"));
            return false;
        }
        return true;
    }

    private void removeAliasFromMap(String alias) {
        allInstancesCFHome.remove(alias);
    }

    public String getSelectedInstPath() {
        return this.selectedInstPath;
    }

    public String getAlias() {
        return this.alias;
    }

    private CFVersions getCFEnumVersion(String versionFromJar) {
        for (CFVersions version : CFVersions.values()) {
            if (!versionFromJar.contains(version.name().substring(2))) continue;
            return version;
        }
        return CFVersions.CF2016;
    }

    @Override
    public CFVersions getCFVersionFromJar(String currentCFHome) {
        Object result = null;
        try {
            if (!Util.validCFHome(new File(currentCFHome))) {
                MessageHandler.getInstance().showError(Messages.getString("invalidCF"));
                return null;
            }
            String cfusionJar = currentCFHome + File.separator + "lib" + File.separator + "cfusion.jar";
            if (!new File(cfusionJar).exists()) {
                cfusionJar = currentCFHome + File.separator + ".." + File.separator + "lib" + File.separator + "cfusion.jar";
            }
            URLClassLoader child = new URLClassLoader(new URL[]{new File(cfusionJar).toURI().toURL()}, this.getClass().getClassLoader());
            Class<?> classToLoad = Class.forName("coldfusion.Version", true, child);
            child.close();
            Method method = classToLoad.getDeclaredMethod("getMajor", new Class[0]);
            Object instance = classToLoad.newInstance();
            result = method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(Messages.getString("invalidCF"));
            return null;
        }
        return this.getCFEnumVersion(result.toString());
    }
}

