/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.json;

import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.json.CustomCharEscapes;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    public static Map<String, Boolean> setAttributes(String settingClass, String jsonFile, List<String> settings) {
        HashMap<String, Boolean> statuses = new HashMap<String, Boolean>();
        Map jsonTree = JsonUtil.getJsonTree(jsonFile);
        String[] userSettingPair = null;
        String userSettingKey = null;
        String userSettingValue = null;
        Iterator<String> itr = settings.iterator();
        if (!settingClass.equals("datasource") && !settingClass.equals("scheduletask")) {
            Map settingMap = (Map)jsonTree.get(settingClass);
            for (Object key : jsonTree.keySet()) {
                if (settingClass.equals(key.toString())) {
                    while (itr.hasNext()) {
                        userSettingPair = itr.next().split("=");
                        userSettingKey = userSettingPair[0];
                        userSettingValue = Util.trimQuotes(userSettingPair[1]);
                        if (!settingMap.containsKey(userSettingKey)) {
                            System.out.println("Invalid setting");
                            statuses.put(userSettingKey, false);
                            continue;
                        }
                        settingMap.put(userSettingKey, userSettingValue);
                        jsonTree.put(settingClass, settingMap);
                    }
                }
                try {
                    String json = JsonUtil.getJsonObjectMapper().writeValueAsString((Object)jsonTree);
                    try (PrintStream out = new PrintStream(new FileOutputStream(jsonFile));){
                        out.print(json);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    statuses.put(userSettingKey, false);
                    continue;
                }
                statuses.put(userSettingKey, true);
            }
        }
        return statuses;
    }

    private static Map getJsonTree(String jsonFile) {
        Map jsonTree = null;
        try {
            ObjectMapper mapper = JsonUtil.getJsonObjectMapper();
            jsonTree = (Map)mapper.readValue(new File(jsonFile), Map.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonTree;
    }

    public static ObjectMapper getJsonObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.getFactory().setCharacterEscapes((CharacterEscapes)new CustomCharEscapes());
        return mapper;
    }

    public static boolean isValidJsonFile(String jsonFile) {
        boolean isValid = false;
        try {
            new URL(jsonFile);
            isValid = true;
        }
        catch (MalformedURLException e) {
            isValid = !StringUtils.isEmpty((CharSequence)jsonFile) && jsonFile.endsWith(".json") && jsonFile.split("\\.")[0].length() > 0 && new File(jsonFile).exists();
        }
        return isValid;
    }

    public static Object getObjectFromMap(Map<String, Object> map, Class cls) {
        return mapper.convertValue(map, cls);
    }

    public static Map getJsonMapFromFile(String filePath) {
        Map jsonMap;
        ObjectMapper mapper = JsonUtil.getJsonObjectMapper();
        try {
            try {
                URL url = new URL(filePath);
                jsonMap = (Map)mapper.readValue(url, Map.class);
            }
            catch (MalformedURLException e) {
                File jsonFile = new File(filePath);
                FileReader reader = new FileReader(jsonFile);
                jsonMap = (Map)new Gson().fromJson((Reader)reader, Map.class);
                reader.close();
            }
        }
        catch (IOException e) {
            throw new CFSetupException(e);
        }
        return jsonMap;
    }

    public static File takeBackUp(GenericSetting genSetting, long timestamp) {
        File xmlFile = genSetting.getXMLFileObject();
        Path src = Paths.get(xmlFile.getAbsolutePath(), new String[0]);
        File backupDir = new File(xmlFile.getParentFile().getAbsolutePath() + File.separator + "cfsetup_backup" + File.separator + timestamp);
        if (!backupDir.exists()) {
            if (!backupDir.getParentFile().exists()) {
                backupDir.getParentFile().mkdir();
            }
            backupDir.mkdir();
        }
        Path dest = Paths.get(backupDir.getAbsolutePath() + File.separator + xmlFile.getName() + ".bkp", new String[0]);
        try {
            Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
            return new File(backupDir.getAbsolutePath() + File.separator + xmlFile.getName() + ".bkp");
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            logger.error("Error while creating backup", (Throwable)e1);
            return null;
        }
    }

    public static void replaceBackup(GenericSetting genSetting, File f) {
        File xmlFile = genSetting.getXMLFileObject();
        Path dest = Paths.get(xmlFile.getAbsolutePath(), new String[0]);
        try {
            Files.copy(Paths.get(f.getAbsolutePath(), new String[0]), dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            logger.error("Error while replacing backup", (Throwable)e1);
        }
    }
}

