/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.SamlService;
import com.adobe.cfsetup.settings.service.SecurityService;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class AdminSamlConfigSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> samlConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File securityFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SECURITY.getFileName());
    private final SecurityService securityService = new SecurityService(this.securityFile, this.selectedPath);
    private final File samlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.IDPCONFIGURATION.getFileName());
    private final SamlService samlService = new SamlService(this.samlFile, this.samlFile.getParentFile().getParent());

    public AdminSamlConfigSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.securityService.getAdminSamlConfigMap());
        this.samlConfigMap = map;
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        if (this.samlConfigMap != null && !this.samlConfigMap.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("alreadyAdded", "samlconfig"));
            return false;
        }
        if (!this.samlService.getAllIdpConfig().containsKey((String)map.get("idpName"))) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSamlValues", "idpName", "IDPCONFIGURATION"));
            return false;
        }
        if (!this.samlService.getAllSpConfig().containsKey((String)map.get("spName"))) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSamlValues", "spName", "SPCONFIGURATION"));
            return false;
        }
        this.samlConfigMap.putAll(map);
        this.securityService.updateSamlConfig(map);
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (!service.equalsIgnoreCase("default")) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, "samlconfig"));
            return false;
        }
        if (this.samlConfigMap == null || this.samlConfigMap.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("notAdded", "samlConfig"));
            return false;
        }
        this.samlConfigMap = null;
        this.securityService.updateSamlConfig(this.samlConfigMap);
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.samlConfigMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        if (AbstractCommand.commandName != CommandName.IMPORT && (this.samlConfigMap == null || this.samlConfigMap.isEmpty())) {
            MessageHandler.getInstance().showError(Messages.getString("cannotUseSet", "samlconfig"));
            return false;
        }
        if (name.equalsIgnoreCase("idpName") && !this.samlService.getAllIdpConfig().containsKey((String)value)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSamlValues", "idpName", "IDPCONFIGURATION"));
            return false;
        }
        if (name.equalsIgnoreCase("spName") && !this.samlService.getAllSpConfig().containsKey((String)value)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSamlValues", "spName", "SPCONFIGURATION"));
            return false;
        }
        return this.updateMap(name, value);
    }

    private boolean updateMap(String name, Object newValue) {
        this.samlConfigMap.put(name, newValue);
        return this.securityService.updateSamlConfig(this.samlConfigMap);
    }

    @Override
    public Map<String, Object> getMap() {
        return this.samlConfigMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.securityFile;
    }

    @Override
    public Category getCategory() {
        return Category.SAMLCONFIG;
    }
}

