/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.EventService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.configuration.XMLConfiguration;

public class EventGatewayGlobalSettings
extends MultiConfigurationBase {
    private final String eventConfigXml = Category.EVENTGATEWAYSETTING.getFileName();
    private Map<String, Object> eventGatewaySettings = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File eventConfigXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + this.eventConfigXml);
    private final EventService eventService;

    public EventGatewayGlobalSettings(String instancePath) {
        super(instancePath);
        this.eventService = new EventService(this.eventConfigXmlFile, instancePath);
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.eventGatewaySettings.forEach(map::put);
        return map;
    }

    @Override
    public XMLConfiguration getCfg() {
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.eventConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.EVENTGATEWAYSETTING;
    }

    @Override
    public void populateMap() {
        this.eventGatewaySettings = this.getGlobalSettings(this.eventService.getGlobals());
    }

    private Map<String, Object> getGlobalSettings(ConfigMap gatewayTypes) {
        HashMap<String, Object> gatewayTypesMap = new HashMap<String, Object>();
        gatewayTypes.forEach((key, value) -> gatewayTypesMap.put((String)key, value));
        return gatewayTypesMap;
    }

    @Override
    public String getSetting(String name, String service) {
        name = name.toUpperCase();
        if (Objects.nonNull(service)) {
            MessageHandler.getInstance().showError(Messages.getString("invailidNumberOfArguments"));
            return null;
        }
        if (!this.eventGatewaySettings.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return this.eventGatewaySettings.get(name).toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value);
    }

    public boolean updateMap(String name, Object newValue) {
        this.eventGatewaySettings.put(name, newValue);
        return this.saveModifiedMap();
    }

    private boolean saveModifiedMap() {
        ConfigMap configMap = new ConfigMap();
        Optional.ofNullable(this.eventGatewaySettings.get("JIGID")).ifPresent(jigid -> configMap.put("JIGID", Cast._String(jigid)));
        Optional.ofNullable(this.eventGatewaySettings.get("THREADPOOLSIZE")).ifPresent(value -> configMap.put("THREADPOOLSIZE", (Object)Cast._double(value)));
        Optional.ofNullable(this.eventGatewaySettings.get("ENABLEEVENTGATEWAYSERVICE")).ifPresent(value -> configMap.put("ENABLEEVENTGATEWAYSERVICE", (Object)Cast._boolean(value)));
        Optional.ofNullable(this.eventGatewaySettings.get("MAXQUEUESIZE")).ifPresent(value -> configMap.put("MAXQUEUESIZE", (Object)Cast._double(value)));
        return this.eventService.saveGatewaySettingMap(configMap);
    }
}

