/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.GraphQLClientConfigService;
import com.adobe.cfsetup.settings.simple.MapObject;
import com.adobe.cfsetup.validation.SettingValidation;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GraphQLClientSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Map<String, Object>> clientSettingsMap;
    private final File clientSettingsFile;
    private GraphQLClientConfigService clientConfigService;
    Map<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public GraphQLClientSettings(String instancePath) {
        super(instancePath);
        this.clientSettingsMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.clientSettingsFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.GRAPHQLCLIENTCONFIG.getFileName());
        this.clientConfigService = new GraphQLClientConfigService(this.clientSettingsFile);
        try {
            PasswordUtils.getInstance(instancePath);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.populateMap();
    }

    @Override
    public void show(String service) {
        TreeMap<String, Object> internalMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        internalMap.putAll(this.getInternalMap());
        this.putDependentSettings(internalMap);
        Map<String, Object> map = this.sortMap(internalMap, 0);
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)this.getCategory().name().toLowerCase().concat(this.showSuffix())), true);
            if (MapUtils.isEmpty(map)) {
                MessageHandler.getInstance().showInfo("\t" + Messages.getString("NoSettingsFound"));
                return;
            }
            map.forEach((sname, value) -> {
                if (value instanceof Map) {
                    this.clientConfigService.decryptField((Map)value, PasswordUtils.getInstance().getSeedValue());
                    if ("*".equals(service) || !(this instanceof MultilevelSetting)) {
                        MessageHandler.getInstance().showBlueAndBold("\t" + sname + ":", true);
                        this.printMap((Map)value, "\t");
                    } else {
                        MessageHandler.getInstance().showInfo((String)sname);
                    }
                } else if (value instanceof Collection) {
                    MessageHandler.getInstance().showGreen("\t" + sname + " : ", true);
                    this.printCollection((Collection)value, "\t\t");
                } else {
                    String userDefinedName = sname;
                    if (!Objects.isNull(userDefinedName)) {
                        String stringValue;
                        if (value instanceof MapObject) {
                            MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                            stringValue = ((MapObject)value).getValue();
                        } else {
                            MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                            stringValue = String.valueOf(value);
                        }
                        String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                        stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                        MessageHandler.getInstance().showInfo(stringValue);
                    }
                }
            });
            return;
        }
        if (!internalMap.containsKey(service)) {
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        Object value2 = map.get(service);
        if (value2 instanceof Map) {
            this.clientConfigService.decryptField((Map)value2, PasswordUtils.getInstance().getSeedValue());
            MessageHandler.getInstance().showGreenAndBold(service + ":", true);
            this.printMap((Map)value2, "");
        } else if (value2 instanceof Collection) {
            MessageHandler.getInstance().showGreen(service + ":", true);
            this.printCollection((Collection)value2, "");
        } else {
            String userDefinedName = service;
            if (!Objects.isNull(userDefinedName)) {
                String stringValue = value2 instanceof MapObject ? ((MapObject)value2).getValue() : String.valueOf(value2);
                String actualSetting = ProposedSetting.getInstance().getActualSetting(this.getCategory(), userDefinedName);
                stringValue = SettingValidation.getInstance().transformToUserValue(this.getCategory(), actualSetting, stringValue);
                MessageHandler.getInstance().showGreen("\t" + userDefinedName + ": ", false);
                MessageHandler.getInstance().showInfo(stringValue);
            }
        }
    }

    @Override
    public void populateMap() {
        this.clientSettingsMap.putAll(new HashMap(this.clientConfigService.getMap()));
        this.flatMap = Util.createFlatMap(this.getCategory(), this.clientSettingsMap);
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object value = Util.getSettingValue(name, service, this.clientSettingsMap);
        if (Objects.nonNull(value)) {
            if ("headers".equals(name)) {
                HashMap<String, Object> headersStruct = new HashMap<String, Object>();
                headersStruct.put("headers", value);
                this.clientConfigService.decryptField(headersStruct, PasswordUtils.getInstance().getSeedValue());
                return String.valueOf(headersStruct.get("headers"));
            }
            return String.valueOf(value);
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
        return null;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("client_name")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        this.checkServiceExists(service);
        try {
            Map settings = this.clientSettingsMap.get(service);
            String[] order = name.split("/");
            Map settingMap = settings;
            for (int i = 0; i < order.length - 1; ++i) {
                Object settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = (Map)settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put((String)settingKey, (Object)value);
            this.clientConfigService.addService(service, settings);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return true;
    }

    private void checkServiceExists(String service) {
        if (!this.clientSettingsMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
    }

    @Override
    public Map<String, ?> getMap() {
        return this.flatMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.clientSettingsFile;
    }

    @Override
    public Category getCategory() {
        return Category.GRAPHQLCLIENTCONFIG;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        this.checkServiceExists(service);
        try {
            this.clientSettingsMap.remove(service);
            this.clientConfigService.storeModifiedMap(this.clientSettingsMap);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean addService(Object val) {
        Map<String, Object> map = (Map<String, Object>)val;
        map = Util.expandNestedFields(map);
        String name = (String)map.get("client_name");
        this.clientConfigService.addService(name, map);
        this.clientSettingsMap.put(name, map);
        this.populateMap();
        return true;
    }
}

