/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.MailService;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class MailSettings
extends MultiConfigurationBase {
    private File mailXmlFile;
    private Map<String, Object> mailSettingMap;
    private MailService service;

    public MailSettings(String instancePath) {
        super(instancePath);
        this.mailXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.MAIL.getFileName());
        this.service = new MailService(this.mailXmlFile, this.mailXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public void populateMap() {
        Map map = this.service.getSettings();
        this.mailSettingMap = new TreeMap<String, Object>(map);
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.mailSettingMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        return this.updateMap(name, value);
    }

    public boolean updateMap(String name, Object newValue) {
        this.mailSettingMap.put(name, newValue);
        return this.service.storeModifiedMap(this.mailSettingMap);
    }

    public Map<String, Object> getMap() {
        return this.mailSettingMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.mailXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.MAIL;
    }
}

