/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.DocumentService;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class PdfServiceSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private File documentXmlFile;
    private Map<String, Object> pdfServiceMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private DocumentService service;
    private static final String NAME = "name";
    private static final String HOSTNAME = "hostname";
    private static final String ENGINE = "engine";
    private static final String WEBKIT = "WebKit";
    private static final String PDFREACTOR = "PdfReactor";

    public PdfServiceSettings(String instancePath) {
        super(instancePath);
        this.documentXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.PDFSERVICE.getFileName());
        this.service = new DocumentService(this.documentXmlFile, this.documentXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public void populateMap() {
        Map map = this.service.getPdfServiceMap();
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                this.pdfServiceMap.put((String)key, new HashMap((Map)value));
            }
        });
    }

    @Override
    public String getSetting(String name, String service) {
        if (!this.pdfServiceMap.containsKey(service)) {
            System.out.println("Invalid pdfservice : " + service);
            return null;
        }
        Map openOfficeMap = (Map)this.pdfServiceMap.get(service);
        if (!openOfficeMap.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return openOfficeMap.get(name).toString();
    }

    public boolean handleLocalHostAssignmentOrImport() {
        String errorMessage = null;
        errorMessage = AbstractCommand.commandName == CommandName.IMPORT ? Messages.getString("PDFSERVICE.canNotBeImport") : Messages.getString("PDFSERVICE.canNotHaveLoopBack");
        MessageHandler.getInstance().showWarning(errorMessage);
        return true;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (service == null) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        if (name.equalsIgnoreCase(HOSTNAME)) {
            try {
                if (PdfServiceSettings.checkForLocalHost(InetAddress.getByName((String)value))) {
                    return this.handleLocalHostAssignmentOrImport();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (name.equalsIgnoreCase(ENGINE)) {
            String engine = (String)value;
            if (engine.equals("1.0") || engine.equals("2.0")) {
                Map map = (Map)this.pdfServiceMap.get(service);
                value = engine.equals("1.0") ? WEBKIT : PDFREACTOR;
                map.put(name, value);
                return this.saveModifiedMap();
            }
            MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.invalidEngineValue"));
            return false;
        }
        if ("localhost".equalsIgnoreCase(service)) {
            MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.canNotBeEdited"));
            return false;
        }
        if ("islocal".equalsIgnoreCase(name)) {
            MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.canNotBeMadeLocal"));
            return false;
        }
        if (!this.pdfServiceMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        Map map = (Map)this.pdfServiceMap.get(service);
        map.put(name, value);
        return this.saveModifiedMap();
    }

    private boolean saveModifiedMap() {
        return this.service.savePdfServiceMap(this.pdfServiceMap);
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("Invalid pdfservice"));
        }
        if (!this.pdfServiceMap.containsKey(service)) {
            System.out.println("Invalid pdfservice");
            return false;
        }
        if ("localhost".equalsIgnoreCase(service)) {
            MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.canNotDelete"));
            return false;
        }
        this.pdfServiceMap.remove(service);
        return this.saveModifiedMap();
    }

    @Override
    public Map<String, Object> getMap() {
        return this.pdfServiceMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.documentXmlFile;
    }

    public static boolean checkForLocalHost(InetAddress ipAddress) {
        if (ipAddress.isAnyLocalAddress() || ipAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(ipAddress) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        try {
            if (PdfServiceSettings.checkForLocalHost(InetAddress.getByName((String)map.get(HOSTNAME))) || "localhost".equalsIgnoreCase((String)map.get(NAME)) || map.containsKey("islocal") && ((Boolean)map.get("islocal")).booleanValue()) {
                return this.handleLocalHostAssignmentOrImport();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (AbstractCommand.commandName == CommandName.IMPORT && map.get(ENGINE) == null) {
            map.put(ENGINE, PDFREACTOR);
        }
        String engine = (String)map.get(ENGINE);
        List<String> engineVals = Arrays.asList("1.0", "2.0", WEBKIT, PDFREACTOR);
        if (engineVals.contains(engine)) {
            if (engine.equals("1.0")) {
                map.put(ENGINE, WEBKIT);
            } else if (engine.equals("2.0")) {
                map.put(ENGINE, PDFREACTOR);
            } else if ((engine.equalsIgnoreCase(WEBKIT) || engine.equalsIgnoreCase(PDFREACTOR)) && AbstractCommand.commandName == CommandName.ADD) {
                MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.invalidEngineValue"));
                return false;
            }
        } else {
            MessageHandler.getInstance().showError(Messages.getString("PDFSERVICE.invalidEngineValue"));
            return false;
        }
        this.pdfServiceMap.put((String)map.get(NAME), map);
        return this.service.savePdfServiceMap(this.pdfServiceMap);
    }

    @Override
    public Category getCategory() {
        return Category.PDFSERVICE;
    }
}

