/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.RpcService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class RpcSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final String NAME = "name";
    private final String rpcConfigXml = Category.WEBSERVICE.getFileName();
    private Map<String, Object> rpcConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File rpcConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.rpcConfigXml);
    private final RpcService rpcService = new RpcService(this.rpcConfigXmlFile);
    private String seed = this.getSeed();

    public RpcSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.rpcConfigMap.forEach(map::put);
        if (CommandName.EXPORT.equals((Object)AbstractCommand.commandName)) {
            map.put("version", this.rpcService.getVersion());
        }
        return map;
    }

    @Override
    public void populateMap() {
        this.rpcConfigMap = this.rpcService.getMap();
    }

    @Override
    public String getSetting(String name, String service) {
        if ("version".equalsIgnoreCase(name)) {
            return this.rpcService.getVersion();
        }
        if (this.rpcConfigMap.get(service) == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.WEBSERVICE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.WEBSERVICE.name()));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        HashMap v = (HashMap)this.rpcConfigMap.get(service);
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.rpcConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.WEBSERVICE;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if ("version".equalsIgnoreCase(name)) {
            this.rpcService.updateVersion((String)value);
            return true;
        }
        if (name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        Map map = (Map)this.rpcConfigMap.get(service);
        if (map == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.WEBSERVICE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.WEBSERVICE.name()));
        }
        map.put(name, value);
        this.rpcConfigMap.put(service, map);
        this.rpcService.storeModifiedMap(this.rpcConfigMap);
        return true;
    }

    @Override
    public boolean addService(Map val, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            val.put(NAME, service);
        }
        return this.addService(val);
    }

    @Override
    public boolean addService(Object val) {
        final HashMap map = new HashMap();
        map.putAll((Map)val);
        final String name = (String)map.get(NAME);
        HashMap m = new HashMap(){
            {
                this.put(name, map);
            }
        };
        this.rpcConfigMap.putAll(m);
        this.rpcService.storeModifiedMap(this.rpcConfigMap);
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (this.rpcConfigMap.get(service) == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", Category.WEBSERVICE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.WEBSERVICE.name()));
        }
        this.rpcConfigMap.remove(service);
        this.rpcService.storeModifiedMap(this.rpcConfigMap);
        return true;
    }

    @Override
    public void show(String service) {
        super.show(service);
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            Util.showSingleSetting(this.getCategory(), "version", this.rpcService.getVersion());
        }
    }

    @Override
    public String showSuffix() {
        return "(s)";
    }
}

