/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.SolrService;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;

public class SolrSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> solrConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Map<String, String>> languages;
    private final File solrConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SOLR.getFileName());
    private final SolrService solrService = new SolrService(this.solrConfigXmlFile);
    public static final String LANGUAGES = "languages";
    private static final String NAME = "name";
    private static final String SUFFIX = "suffix";

    public SolrSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.solrConfigMap.forEach(map::put);
        map.remove(LANGUAGES);
        map.put("language", this.languages);
        return map;
    }

    @Override
    public Map<String, ?> getInternalMap() {
        HashMap map = new HashMap();
        this.solrConfigMap.forEach(map::put);
        Vector vector = new Vector();
        this.languages.forEach((key, value) -> {
            ConfigMap configMap = new ConfigMap();
            configMap.put(NAME, value.get(NAME));
            configMap.put(SUFFIX, value.get(SUFFIX));
            vector.add(configMap);
        });
        map.put(LANGUAGES, vector);
        return map;
    }

    @Override
    public XMLConfiguration getCfg() {
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.solrConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.SOLR;
    }

    @Override
    public void populateMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.solrService.getMap());
        this.solrConfigMap = map;
        this.languages = this.populateLanguages(this.solrConfigMap);
        this.solrConfigMap.put(LANGUAGES, this.languages);
    }

    private Map<String, Map<String, String>> populateLanguages(Map map) {
        TreeMap<String, Map<String, String>> output = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
        map.getOrDefault(LANGUAGES, new Vector()).forEach(l -> {
            if (l instanceof ConfigMap) {
                ConfigMap languageMap = (ConfigMap)l;
                HashMap<String, String> lMap = new HashMap<String, String>();
                lMap.put(NAME, (String)languageMap.get(NAME));
                lMap.put(SUFFIX, (String)languageMap.get(SUFFIX));
                output.put((String)languageMap.get(NAME), lMap);
            }
        });
        return output;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        if (LANGUAGES.equals(name)) {
            StringBuilder languagesString = new StringBuilder();
            this.languages.forEach((key, value) -> languagesString.append((String)key).append(": ").append(value).append("\n"));
            return languagesString.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("SOLR.invalidService"));
            return null;
        }
        Object object = this.solrConfigMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return String.valueOf(object);
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if ("language".equals(service)) {
            MessageHandler.getInstance().showError(Messages.getString("setOperationAllowedForLanguage"));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("SOLR.invalidService"));
            return false;
        }
        this.solrConfigMap.put(name, value);
        this.storeModifiedMap();
        return true;
    }

    @Override
    public boolean validate(Map<String, Object> keyValue, String service) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getMap());
        map.putAll(keyValue);
        if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            this.solrService.checkSolrHomePath((String)map.get("solrhost"), (String)map.get("solrhome"));
        }
        return true;
    }

    private boolean updateLanguage(Map<String, String> languages, Map<String, Object> solrConfigMap) {
        Vector vector = new Vector();
        languages.forEach((key, value) -> {
            ConfigMap configMap = new ConfigMap();
            configMap.put(NAME, key);
            configMap.put(SUFFIX, value);
            vector.add(configMap);
        });
        solrConfigMap.put(LANGUAGES, vector);
        this.solrService.storeModifiedMap(solrConfigMap);
        return true;
    }

    @Override
    public synchronized boolean addService(Object val) {
        MessageHandler.getInstance().showError(Messages.getString("SOLR.onlyAddLanguage"));
        return false;
    }

    @Override
    public boolean addService(Map val, String service) {
        if (StringUtils.isBlank((CharSequence)service) || !"language".equals(service)) {
            MessageHandler.getInstance().showError(Messages.getString("SOLR.onlyAddLanguage"));
            return false;
        }
        Map languageMap = val;
        if (languageMap.containsKey(NAME)) {
            Map lMap = this.languages.getOrDefault(languageMap.get(NAME), new HashMap());
            if (StringUtils.isBlank((CharSequence)((String)languageMap.get(NAME))) || StringUtils.isBlank((CharSequence)((String)languageMap.get(SUFFIX)))) {
                MessageHandler.getInstance().showError(Messages.getString("solrLanguageError"));
            }
            lMap.put(NAME, String.valueOf(languageMap.get(NAME)));
            lMap.put(SUFFIX, String.valueOf(languageMap.get(SUFFIX)));
            this.languages.put(String.valueOf(languageMap.get(NAME)), lMap);
        } else {
            HashMap<String, Map> langMapToAdd = new HashMap<String, Map>();
            for (Object value : languageMap.values()) {
                if (!(value instanceof Map)) continue;
                Map map = (Map)value;
                Map lMap1 = this.languages.getOrDefault(map.get(NAME), new HashMap());
                if (!map.containsKey(NAME)) continue;
                if (StringUtils.isBlank((CharSequence)((CharSequence)map.get(NAME))) || StringUtils.isBlank((CharSequence)((CharSequence)map.get(SUFFIX)))) {
                    MessageHandler.getInstance().showError(Messages.getString("solrLanguageError"));
                }
                lMap1.put(NAME, String.valueOf(map.get(NAME)));
                lMap1.put(SUFFIX, String.valueOf(map.get(SUFFIX)));
                langMapToAdd.put(String.valueOf(map.get(NAME)), lMap1);
            }
            this.languages.putAll(langMapToAdd);
        }
        return this.storeModifiedMap();
    }

    private boolean storeModifiedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.solrConfigMap);
        Vector vector = new Vector();
        this.languages.forEach((key, value) -> {
            ConfigMap configMap = new ConfigMap();
            configMap.put(NAME, value.get(NAME));
            configMap.put(SUFFIX, value.get(SUFFIX));
            vector.add(configMap);
        });
        map.put(LANGUAGES, vector);
        return this.solrService.storeModifiedMap(map);
    }

    @Override
    public boolean deleteService(String service) {
        MessageHandler.getInstance().showError(Messages.getString("SOLR.onlyAddLanguage"));
        return false;
    }

    @Override
    public boolean deleteService(Map<String, List> keyValueMap, String service) {
        if (StringUtils.isBlank((CharSequence)service) || !"language".equals(service)) {
            MessageHandler.getInstance().showError(Messages.getString("SOLR.onlyDeleteLanguage"));
            return false;
        }
        List list = keyValueMap.get(NAME);
        for (String name : list) {
            if (this.languages.containsKey(name)) {
                this.languages.remove(name);
                continue;
            }
            MessageHandler.getInstance().showError(Messages.getString("SOLR.languageNotFound", name));
            return false;
        }
        return this.storeModifiedMap();
    }
}

