/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.security.SecurityUtils;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.service.SecurityService;
import com.adobe.cfsetup.validation.RegexValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> userConfigMap;
    private Map<String, Object> securityConfigMap;
    private final File securityFile;
    private final SecurityService securityService;
    private final RegexValidation regexValidation;
    private final int USERNAME_LENGTH_MIN = 5;
    private final int USERNAME_LENGTH_MAX = 20;
    private static final Logger logger = LoggerFactory.getLogger(UserSettings.class);
    Set<String> specialRoles = new HashSet<String>(Arrays.asList("coldfusion.administrator", "coldfusion.rds", "coldfusion.adminapi"));

    public UserSettings(String instancePath) {
        super(instancePath);
        this.userConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.securityFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SECURITY.getFileName());
        this.securityService = new SecurityService(this.securityFile, this.selectedPath);
        this.regexValidation = new RegexValidation();
        this.populateMap();
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.securityService.getUsersMap());
        this.userConfigMap = map;
        this.securityConfigMap = this.securityService.getSecurityConfigMap();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("username")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        Map map = (Map)this.userConfigMap.get(service);
        if (value instanceof List) {
            value = new HashSet((List)((Object)value));
        }
        map.put(name, value);
        if ("password".equalsIgnoreCase(name) && !this.encryptPasswordInMap((String)((Object)value), map)) {
            return false;
        }
        this.securityService.updateUserData(this.userConfigMap);
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        Map v = (Map)this.userConfigMap.get(service);
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        if (object instanceof Set) {
            return StringUtils.join(new TreeSet((Set)object), (String)",");
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.securityFile;
    }

    @Override
    public Category getCategory() {
        return Category.USER;
    }

    @Override
    public Map<String, ?> getMap() {
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.userConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public boolean addService(Object val) {
        return this.addService((Map)val, null);
    }

    @Override
    public boolean addService(Map keyValueMap, String service) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.userConfigMap);
        if (AbstractCommand.commandName == CommandName.IMPORT) {
            Util.updateListToSet(keyValueMap);
        }
        if (!StringUtils.isBlank((String)service) && map.get(service) != null) {
            Map userMap = (Map)map.get(service);
            Iterator iterator = keyValueMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof Set) {
                    Set newValues = (Set)v;
                    ArrayList<String> alreadyPresentList = new ArrayList<String>();
                    for (String newValue : newValues) {
                        Set existingValue = (Set)((Map)map.get(service)).get(k);
                        if (!existingValue.contains(newValue)) continue;
                        alreadyPresentList.add(newValue);
                    }
                    if (alreadyPresentList.size() > 0 && AbstractCommand.commandName != CommandName.IMPORT) {
                        MessageHandler.getInstance().showError(Messages.getString("User.alreadyPresent", StringUtils.join(alreadyPresentList, (String)","), service, ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), k)));
                        return false;
                    }
                    ((Set)userMap.get(k)).addAll((Set)v);
                    continue;
                }
                userMap.put(k, v);
            }
        } else {
            String password = "";
            String username = (String)keyValueMap.get("username");
            boolean isLdap = (Boolean)keyValueMap.get("isLdap");
            boolean isSaml = (Boolean)keyValueMap.get("isSaml");
            boolean isGroup = (Boolean)keyValueMap.get("isGroup");
            if (keyValueMap.containsKey("password")) {
                password = (String)keyValueMap.get("password");
            }
            if (!isLdap && !isSaml && username.length() < 5 || username.length() > 20) {
                MessageHandler.getInstance().showError(Messages.getString("usernameLengthInvalid", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "username"), String.valueOf(5), String.valueOf(20)));
                return false;
            }
            if (!isLdap && !isSaml && password.isEmpty()) {
                MessageHandler.getInstance().showError(Messages.getString("passwordRequired"));
                return false;
            }
            if (AbstractCommand.commandName != CommandName.IMPORT && !this.encryptPasswordInMap((String)keyValueMap.get("password"), keyValueMap)) {
                return false;
            }
            map.put(username, keyValueMap);
        }
        this.securityService.updateUserData(map);
        this.userConfigMap = map;
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        return this.deleteService(null, service);
    }

    @Override
    public boolean deleteService(Map<String, List> keyValueMap, String service) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.userConfigMap);
        if (keyValueMap.containsKey("roles") && keyValueMap.get("roles").contains("coldfusion.adminapi") && !keyValueMap.get("roles").contains("coldfusion.administrator") && ((Set)((Map)map.get(service)).get("roles")).contains("coldfusion.administrator")) {
            keyValueMap.get("roles").add("coldfusion.administrator");
        }
        if (MapUtils.isEmpty(keyValueMap)) {
            map.remove(service);
        } else {
            for (Map.Entry<String, List> entry : keyValueMap.entrySet()) {
                Set existingValue;
                String key = entry.getKey();
                List val = entry.getValue();
                if (val.contains("")) {
                    existingValue = (Set)((Map)map.get(service)).get(key);
                    if (existingValue.size() == 0) {
                        MessageHandler.getInstance().showError(Messages.getString("User.alreadyEmpty", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), key), service));
                        return false;
                    }
                    ((Map)map.get(service)).put(key, new HashSet());
                    continue;
                }
                if (val.size() <= 0) continue;
                existingValue = (Set)((Map)map.get(service)).get(key);
                if (existingValue.size() == 0) {
                    MessageHandler.getInstance().showError(Messages.getString("User.notPresent", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), key), service));
                    return false;
                }
                existingValue = (Set)((Map)map.get(service)).get(key);
                ArrayList<String> unpresentList = new ArrayList<String>();
                for (String value : val) {
                    if (existingValue.contains(value)) continue;
                    unpresentList.add(value);
                }
                if (unpresentList.size() > 0) {
                    MessageHandler.getInstance().showError(Messages.getString("User.notPresent1", StringUtils.join(unpresentList, (String)","), service, ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), key), StringUtils.join((Collection)existingValue, (String)",")));
                    return false;
                }
                ((Set)((Map)map.get(service)).get(key)).removeAll(new HashSet(val));
            }
        }
        this.securityService.updateUserData(map);
        this.userConfigMap = map;
        return true;
    }

    private boolean encryptPasswordInMap(String password, Map<String, Object> map) {
        String salt = SecurityUtils.getNewSalt();
        try {
            password = SecurityUtils.hash(SecurityUtils.hash(password, "SHA-1", "", ""), "SHA-256", "", salt);
        }
        catch (IOException e) {
            logger.error("Error encrypting password");
            return false;
        }
        map.put("password", password);
        map.put("salt", salt);
        return true;
    }

    @Override
    public boolean validate(Map<String, Object> keyValueMap, String service) {
        Util.updateListToSet(keyValueMap);
        if (keyValueMap.containsKey("password")) {
            boolean isSecureProfileEnabled = (Boolean)this.securityConfigMap.getOrDefault("secureprofile.enabled", false);
            this.regexValidation.setValidationCriteria("^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*#?&])[A-Za-z\\d@$!%*#?&]{8,}$");
            if (isSecureProfileEnabled && !this.regexValidation.validate((String)keyValueMap.get("password"))) {
                MessageHandler.getInstance().showError(Messages.getString("passwordValidationSecureProfile"));
                return false;
            }
            return true;
        }
        Set<String> services = this.securityService.loadResource(this.selectedPath, "coldfusion/security/exposedservices.properties");
        Set<String> roles = this.securityService.loadResource(this.selectedPath, "coldfusion/security/roles.properties");
        HashSet currRolesPlaceHolder = new HashSet();
        HashSet currServicesPlaceholder = new HashSet();
        currRolesPlaceHolder.addAll(keyValueMap.getOrDefault("roles", new HashSet()));
        currServicesPlaceholder.addAll(keyValueMap.getOrDefault("exposedServices", new HashSet()));
        currRolesPlaceHolder.removeAll(roles);
        currRolesPlaceHolder.removeAll(this.specialRoles);
        if (currRolesPlaceHolder.size() > 0) {
            roles.addAll(this.specialRoles);
            roles.remove("coldfusion.admindefault");
            String roleName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "roles");
            TreeSet<String> sortedRoles = new TreeSet<String>(roles);
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", roleName));
            Util.printAllowedValues(roleName, sortedRoles);
            return false;
        }
        currServicesPlaceholder.removeAll(services);
        if (currServicesPlaceholder.size() > 0) {
            String serviceName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "exposedServices");
            TreeSet<String> sortedServices = new TreeSet<String>(services);
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", serviceName));
            Util.printAllowedValues(serviceName, sortedServices);
            return false;
        }
        HashSet currDatasourcesPlaceholder = new HashSet();
        currDatasourcesPlaceholder.addAll(keyValueMap.getOrDefault("datasources", new HashSet()));
        Set<String> datasources = new DatasourceSettings(this.selectedPath).getMap().keySet();
        currDatasourcesPlaceholder.removeAll(datasources);
        if (currDatasourcesPlaceholder.size() > 0 && !currDatasourcesPlaceholder.contains("*")) {
            TreeSet<String> sortedDatasources = new TreeSet<String>(datasources);
            String dbName = ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "datasources");
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal", dbName));
            if (CollectionUtils.isNotEmpty(sortedDatasources)) {
                sortedDatasources.add("*");
            }
            Util.printAllowedValues(dbName, sortedDatasources);
            return false;
        }
        Set currDatasources = keyValueMap.getOrDefault("datasources", new HashSet());
        if (currDatasources.contains("*")) {
            currDatasources.clear();
            currDatasources.add("*");
        }
        return true;
    }
}

