/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.nested;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;

public class CustomTagsSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private String customTagXml = Category.RUNTIME.getFileName();
    private File customTagsXmlFile;
    private Map<String, Object> customTagsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private RuntimeService service;

    public CustomTagsSettings(String instancePath) {
        super(instancePath);
        this.customTagsXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + this.customTagXml);
        this.intialize();
    }

    private void intialize() {
        this.service = new RuntimeService(this.customTagsXmlFile, this.customTagsXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public String getSetting(String name, String service) {
        if (this.customTagsMap.containsKey(name)) {
            return String.valueOf(this.customTagsMap.get(name));
        }
        MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", name, this.getCategory().name()));
        return null;
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        String value = (String)map.get("customTagPath");
        if (this.customTagsMap.containsValue(value)) {
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                MessageHandler.getInstance().showWarning(Messages.getString("customTagAlreadyPresent", String.valueOf(value)));
            }
            return true;
        }
        String key = "/WEB-INF/customtags".concat(String.valueOf(System.currentTimeMillis()));
        this.customTagsMap.put(key, value);
        return this.service.saveModifiedCustomtagsMap(this.customTagsMap);
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("customTagPath", (String)value);
            return this.addService(map);
        }
        throw new CFSetupException(Messages.getString("operationNotSupported2", this.getCategory().name()));
    }

    @Override
    public void populateMap() {
        this.customTagsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.customTagsMap.putAll(this.service.getCustomtags());
    }

    @Override
    public Map<String, Object> getMap() {
        return this.customTagsMap;
    }

    @Override
    public XMLConfiguration getCfg() {
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.customTagsXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.CUSTOMTAG;
    }

    @Override
    public void show(String service) {
        MessageHandler.getInstance().showGreenAndBold(StringUtils.capitalize((String)this.getCategory().name().toLowerCase().concat(this.showSuffix())), true);
        if (MapUtils.isEmpty(this.customTagsMap)) {
            MessageHandler.getInstance().showInfo("\t" + Messages.getString("NoSettingsFound"));
            return;
        }
        TreeList list = new TreeList(this.customTagsMap.values());
        for (Object obj : list) {
            MessageHandler.getInstance().showInfo("\t".concat(String.valueOf(obj)), true);
        }
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        for (Map.Entry<String, Object> entry : this.customTagsMap.entrySet()) {
            if (!service.equalsIgnoreCase(String.valueOf(entry.getValue()))) continue;
            this.customTagsMap.remove(entry.getKey());
            return this.service.saveModifiedCustomtagsMap(this.customTagsMap);
        }
        return false;
    }
}

