/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientVariableService
extends ServiceBase {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private File mFile = null;
    private ConfigMap mClientStores = null;
    private ConfigMap mClientSettings = null;
    private static final String COLON = ":";

    public ClientVariableService(File file) {
        this.mFile = file;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException(Messages.getString("CLIENTVARIABLE.error.load"), e);
        }
        this.setEnableWatch(true);
        this.setWatchFile(this.mFile);
    }

    public Map getClientVariables() {
        ConfigMap configMap = new ConfigMap((Map)this.mClientStores);
        configMap.putAll((Map)this.mClientSettings);
        return configMap;
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.mFile);
            this.mClientStores = (ConfigMap)v.elementAt(0);
            this.mClientSettings = (ConfigMap)v.elementAt(1);
            this.handlePurgeIntervalType(this.mClientSettings);
            this.normalizeClientStoresKeys(this.mClientStores);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
        this.mClientStores.init(this, "client_stores");
        this.initMap(this.mClientStores, "client_stores");
        this.mClientSettings.init(this, "client_settings");
    }

    private void normalizeClientStoresKeys(ConfigMap mClientStores) {
        mClientStores.keySet().forEach(clientStoreKey -> {
            Object clientStore = mClientStores.get(clientStoreKey);
            if (clientStore instanceof Map) {
                Map clientStoreValue = (Map)clientStore;
                ConfigMap updatedClientStoreValue = new ConfigMap();
                clientStoreValue.forEach((key, value) -> updatedClientStoreValue.put(key.toLowerCase(), value));
                mClientStores.put(clientStoreKey, clientStoreValue);
            }
        });
    }

    @Override
    public void store() throws ServiceException {
        super.store();
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.mClientStores);
        this.updatePurgeIntervalType(this.mClientSettings);
        v.addElement(this.mClientSettings);
        this.serialize(v, this.mFile);
    }

    public boolean saveModifiedMap(Map<String, Object> clientVariablesMap) {
        this.mClientSettings.clear();
        this.mClientStores.clear();
        clientVariablesMap.forEach((key, value) -> {
            if ("default".equalsIgnoreCase((String)key)) {
                this.mClientSettings.put("default", value);
            } else if ("PURGE_INTERVAL".equalsIgnoreCase((String)key)) {
                this.mClientSettings.put("PURGE_INTERVAL", value);
            } else if ("uuidToken".equalsIgnoreCase((String)key)) {
                this.mClientSettings.put("uuidToken", value);
            } else if ("Registry".equalsIgnoreCase((String)key)) {
                this.mClientStores.put("Registry", value);
            } else if ("Cookie".equalsIgnoreCase((String)key)) {
                this.mClientStores.put("Cookie", value);
            } else {
                this.mClientStores.put(key, value);
            }
        });
        try {
            this.store();
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("CLIENTVARIABLE.error.store"), (Throwable)e);
            return false;
        }
        return true;
    }

    private void handlePurgeIntervalType(ConfigMap mClientSettings) {
        String purgeInterval;
        if (mClientSettings.containsKey("PURGE_INTERVAL") && (purgeInterval = (String)mClientSettings.get("PURGE_INTERVAL")) != null && purgeInterval.contains(COLON)) {
            mClientSettings.put("PURGE_INTERVAL", (Object)this.getTotalMinutes(purgeInterval));
        }
    }

    private void updatePurgeIntervalType(ConfigMap mClientSettings) {
        Object purgeInterval;
        if (mClientSettings.containsKey("PURGE_INTERVAL") && (purgeInterval = mClientSettings.get("PURGE_INTERVAL")) != null && !String.valueOf(purgeInterval).contains(COLON)) {
            mClientSettings.put("PURGE_INTERVAL", this.getPurgeIntervalString(String.valueOf(purgeInterval)));
        }
    }

    private int getTotalMinutes(String formattedPurgeInterval) {
        String[] timeParts = formattedPurgeInterval.split(COLON);
        if (timeParts.length != 2) {
            throw new CFSetupException(Messages.getString("CLIENTVARIABLE.error.invalidPurgeInterval"));
        }
        int hours = Integer.parseInt(timeParts[0]);
        int minutes = Integer.parseInt(timeParts[1]);
        return hours * 60 + minutes;
    }

    private String getPurgeIntervalString(String purgeInterval) {
        int totalMinutes = (Integer)Util.getValueByType("int", purgeInterval);
        if (totalMinutes <= 0) {
            throw new CFSetupException(Messages.getString("CLIENTVARIABLE.error.invalidPurgeInterval"));
        }
        int hours = totalMinutes / 60;
        int minutes = totalMinutes % 60;
        return hours + COLON + minutes;
    }
}

