/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CronService
extends ServiceBase {
    private ConfigMap settings = null;
    private File file;
    private boolean _logFlag;
    private String dsname;
    private String extensions;

    public CronService(File cronConfigXmlFile) {
        this.file = cronConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading Cron settings, ", e);
        }
    }

    public Map getMap() {
        HashMap map = new HashMap();
        this.settings.forEach((key, value) -> {
            Object k = (String)key;
            String task = (String)((Map)value).get("task");
            String group = (String)((Map)value).get("group");
            String mode = (String)((Map)value).get("mode");
            String appname = mode.equalsIgnoreCase("server") ? "" : ":" + (String)((Map)value).get("appname");
            k = task + ":" + group + ":" + mode + appname;
            map.put(((String)k).toUpperCase(), value);
        });
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.settings = (ConfigMap)v.elementAt(0);
            Boolean flag = (Boolean)v.elementAt(1);
            boolean bl = this._logFlag = flag == null ? false : flag;
            if (v.size() > 2) {
                this.dsname = (String)v.elementAt(2);
            }
            if (v.size() > 3) {
                this.extensions = (String)v.elementAt(3);
                if (null == this.extensions || this.extensions.length() == 0) {
                    this.extensions = "txt,log";
                }
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.file);
    }

    public void updateLogging(boolean logFlag) {
        this._logFlag = logFlag;
        this.update();
    }

    public Boolean getLogFlag() {
        return this._logFlag;
    }

    public void updateDatasource(String dsName) {
        this.dsname = dsName;
        this.update();
    }

    private void update() {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.settings);
        v.addElement(this._logFlag);
        v.addElement(this.dsname);
        v.addElement(this.extensions);
        this.serialize(v, this.file);
    }

    public String getDatasource() {
        return this.dsname;
    }

    public void storeModifiedMap(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        this.update();
    }
}

