/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService
extends ServiceBase {
    private static final String GLOBAL = "GLOBAL";
    private File _configFile = null;
    private static Logger logger = LoggerFactory.getLogger(EventService.class);
    private static boolean bEventService = false;
    private static ConfigMap settings;
    private static Vector gateways;
    private static Vector instances;
    private static ConfigMap global;
    private static int threadpoolsize;
    private static int devloperThreadLimit;
    private static int standardThreadLimit;
    private static int maxqueuesize;
    private static int devloperQueueLimit;
    private static String jigid;
    private static boolean bJigid;
    private static final long cert_checksum = 1445857997L;
    private static final String trustedSubject = "Zion Software, LLC";
    private static boolean bDeveloperEdition;
    private static boolean bStandardEdition;
    private ConfigMap gatewayType_map = new ConfigMap();
    private ConfigMap instance_map = new ConfigMap();
    private ConfigMap gwinfo_map = new ConfigMap();
    private final String rootDirPattern = "{cf.rootdir}";
    private final int rootDirLen = "{cf.rootdir}".length();
    private String rootdir = null;
    private int status = 1;
    private static final String sd = "[B@cbf92";
    private boolean jbuddyIMGatewayInitialized;
    public static final String ENABLEEVENTGATEWAYSERVICE = "ENABLEEVENTGATEWAYSERVICE";
    public static final String THREADPOOLSIZE = "THREADPOOLSIZE";
    public static final String MAXQUEUESIZE = "MAXQUEUESIZE";
    public static final String JIGID = "JIGID";
    private static final String GATEWAYS = "GATEWAYS";
    private static final String INSTANCES = "INSTANCES";
    public static final String TYPE = "TYPE";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String CLASS = "CLASS";
    public static final String STARTTIMEOUT = "STARTTIMEOUT";
    public static final String KILLONTIMEOUT = "KILLONTIMEOUT";
    public static final String GATEWAYID = "GATEWAYID";
    public static final String CONFIGURATIONPATH = "CONFIGURATIONPATH";
    public static final String CFCPATHS = "CFCPATHS";
    public static final String MODE = "MODE";

    public EventService(File f, String rd) {
        this(f);
        this.rootdir = rd;
    }

    private EventService(File eventConfigXmlFile) {
        this._configFile = eventConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error("Error initializing EventService", (Throwable)e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            settings = (ConfigMap)this.deserialize(this._configFile);
            settings.init(this, "configuration");
            if (this.setSettings(settings)) {
                this.store();
            }
            settings.setConfigMapListener(this);
            global.setConfigMapListener(this);
        }
        catch (Throwable ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.setSettings(settings);
        this.serialize(settings, this._configFile);
        settings.setUnchanged();
    }

    public Map getSettings() {
        return settings;
    }

    public Vector getGateways() {
        return instances;
    }

    public Map getGatewayInfo(String gwID) {
        return (Map)this.instance_map.get(gwID);
    }

    public Vector getGatewayTypes() {
        return gateways;
    }

    public Map getGatewayTypeInfo(String type) {
        return (Map)this.gatewayType_map.get(type);
    }

    public ConfigMap getGlobals() {
        return global;
    }

    public synchronized void setEnable(boolean bEnable) throws ServiceException {
        global.put(ENABLEEVENTGATEWAYSERVICE, bEnable ? Boolean.TRUE : Boolean.FALSE);
        if (!bEnable) {
            this.stop();
        } else {
            this.start();
        }
    }

    public synchronized void setThreadpoolsize(int size) {
        if (bDeveloperEdition && threadpoolsize > devloperThreadLimit) {
            size = devloperThreadLimit;
        }
        if (bStandardEdition && threadpoolsize > standardThreadLimit) {
            size = standardThreadLimit;
        }
        threadpoolsize = size;
        global.put(THREADPOOLSIZE, new Integer(threadpoolsize));
    }

    public synchronized void setMaxqueuesize(int size) {
        if (bDeveloperEdition && maxqueuesize > devloperQueueLimit) {
            size = devloperQueueLimit;
        }
        maxqueuesize = size;
        global.put(MAXQUEUESIZE, new Integer(maxqueuesize));
    }

    public synchronized void updateGatewayMode(String gwID, String startup) {
        String mode = startup.toUpperCase();
        if (!(mode.equals("AUTO") || mode.equals("MANUAL") || mode.equals("DISABLED"))) {
            throw new ServiceRuntimeException(Messages.getString("EventService.BadMode"));
        }
        Object entry = this.instance_map.get(gwID);
        if (entry != null) {
            ((ConfigMap)entry).put(MODE, mode);
        }
        this.mapModified();
    }

    public synchronized void registerGatewayType(String typeName, String description, String javaClass, int timeout, boolean kill) throws ServiceRuntimeException {
        Object entry = this.gatewayType_map.get(typeName);
        if (entry != null) {
            this.gatewayType_map.remove(typeName);
            gateways.remove(entry);
        }
        ConfigMap gw = new ConfigMap();
        gw.put(TYPE, typeName);
        gw.put(DESCRIPTION, description);
        gw.put(CLASS, javaClass);
        gw.put(STARTTIMEOUT, (Object)timeout);
        gw.put(KILLONTIMEOUT, (Object)kill);
        this.gatewayType_map.put(typeName, gw);
        gateways.add(gw);
        this.mapModified();
    }

    public synchronized void registerGateway(String gwID, String type, String config, String[] cfcpaths, String startup) throws ServiceRuntimeException {
        String mode = startup.toUpperCase();
        if (!(mode.equals("AUTO") || mode.equals("MANUAL") || mode.equals("DISABLED"))) {
            MessageHandler.getInstance().showError(Messages.getString("EventService.BadMode"));
            throw new ServiceRuntimeException(Messages.getString("EventService.BadMode"));
        }
        String expandedConfig = "";
        if (StringUtils.isNotBlank((CharSequence)config)) {
            expandedConfig = config.replace("{cf.rootdir}", this.rootdir);
            File configFile = new File(expandedConfig);
            if (!(CommandName.IMPORT.equals((Object)AbstractCommand.commandName) || configFile.exists() && configFile.isFile())) {
                MessageHandler.getInstance().showError(Messages.getString("missingFile", "Event Configuration", configFile.getAbsolutePath()));
                throw new ServiceRuntimeException(Messages.getString("missingFile", "Event Configuration", configFile.getName()));
            }
        }
        Vector<String> cfcs = new Vector<String>(cfcpaths.length);
        for (int i = 0; i < cfcpaths.length; ++i) {
            Object path = cfcpaths[i];
            if (((String)path).indexOf("{cf.rootdir}") != -1) {
                path = this.rootdir + ((String)path).substring(((String)path).indexOf("{cf.rootdir}") + this.rootDirLen);
            }
            File f = new File((String)path);
            if (!(CommandName.IMPORT.equals((Object)AbstractCommand.commandName) || f.exists() && f.isFile())) {
                MessageHandler.getInstance().showError(Messages.getString("missingCFC", f.getName()));
                throw new ServiceRuntimeException(Messages.getString("missingCFC", f.getAbsolutePath()));
            }
            cfcs.add(f.getAbsolutePath());
        }
        Object entry = this.instance_map.get(gwID);
        if (entry != null) {
            this.removeGateway(gwID);
        }
        ConfigMap gw = new ConfigMap();
        gw.put(GATEWAYID, gwID);
        gw.put(TYPE, type);
        gw.put(CONFIGURATIONPATH, expandedConfig);
        gw.put(CFCPATHS, cfcs);
        gw.put(MODE, mode);
        this.instance_map.put(gwID, gw);
        instances.add(gw);
        this.mapModified();
    }

    public synchronized void removeGatewayType(String type) throws ServiceRuntimeException {
        ConfigMap typeInfo = (ConfigMap)this.gatewayType_map.get(type);
        if (typeInfo == null) {
            throw new ServiceRuntimeException(Messages.getString("serviceDoesNotExist", type, Category.EVENTGATEWAYTYPE.name()));
        }
        Enumeration e = this.instance_map.elements();
        while (e.hasMoreElements()) {
            ConfigMap configMap = (ConfigMap)e.nextElement();
            if (!type.equals(configMap.get(TYPE))) continue;
            this.removeGateway((String)configMap.get(GATEWAYID));
        }
        this.gatewayType_map.remove(type);
        gateways.remove(typeInfo);
        this.mapModified();
    }

    public synchronized void removeGateway(String gwID) throws ServiceRuntimeException {
        Map gwConfig = (Map)this.instance_map.get(gwID);
        if (gwConfig == null) {
            throw new ServiceRuntimeException(Messages.getString("EventService.UnknownGateway"));
        }
        this.instance_map.remove(gwID);
        instances.remove(gwConfig);
        this.gwinfo_map.remove(gwID);
        this.mapModified();
    }

    private boolean setSettings(Map settings) {
        boolean dosave = false;
        gateways = (Vector)settings.get(GATEWAYS);
        global = (ConfigMap)settings.get(GLOBAL);
        instances = (Vector)settings.get(INSTANCES);
        bEventService = global.get(ENABLEEVENTGATEWAYSERVICE) != null && (Boolean)global.get(ENABLEEVENTGATEWAYSERVICE) != false;
        threadpoolsize = global.get(THREADPOOLSIZE) != null ? ((Number)global.get(THREADPOOLSIZE)).intValue() : threadpoolsize;
        maxqueuesize = global.get(MAXQUEUESIZE) != null ? ((Number)global.get(MAXQUEUESIZE)).intValue() : maxqueuesize;
        jigid = global.get(JIGID) != null ? (String)global.get(JIGID) : null;
        Enumeration e = gateways.elements();
        while (e.hasMoreElements()) {
            ConfigMap gateway = (ConfigMap)e.nextElement();
            this.gatewayType_map.put(gateway.get(TYPE), gateway);
        }
        e = instances.elements();
        while (e.hasMoreElements()) {
            ConfigMap instance = (ConfigMap)e.nextElement();
            this.instance_map.put(instance.get(GATEWAYID), instance);
        }
        int tl = threadpoolsize;
        int ql = maxqueuesize;
        bStandardEdition = true;
        tl = standardThreadLimit;
        if (threadpoolsize > tl) {
            threadpoolsize = tl;
            global.put(THREADPOOLSIZE, new Integer(threadpoolsize));
            dosave = true;
        }
        if (maxqueuesize > ql) {
            maxqueuesize = ql;
            global.put(MAXQUEUESIZE, new Integer(maxqueuesize));
            dosave = true;
        }
        return dosave;
    }

    public ConfigMap getGatewayTypeMap() {
        return this.gatewayType_map;
    }

    public boolean saveGatewayTypeMap(ConfigMap configMap) {
        this.gatewayType_map = configMap;
        Vector vector = new Vector();
        configMap.values().forEach(vector::add);
        settings.put(GATEWAYS, vector);
        gateways = vector;
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing event", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean saveGatewayInstanceMap(ConfigMap configMap) {
        this.instance_map = configMap;
        Vector vector = new Vector();
        configMap.values().forEach(vector::add);
        settings.put(INSTANCES, vector);
        instances = vector;
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing event", (Throwable)e);
            return false;
        }
        return true;
    }

    public ConfigMap getEventGatewayInstances() {
        return this.instance_map;
    }

    public ConfigMap getEventGatewaySetting() {
        return this.getGlobals();
    }

    public boolean saveGatewaySettingMap(ConfigMap configMap) {
        settings.put(GLOBAL, configMap);
        this.setSettings(settings);
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing event", (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        threadpoolsize = 5;
        devloperThreadLimit = 1;
        standardThreadLimit = 1;
        maxqueuesize = 25000;
        devloperQueueLimit = 10;
        jigid = null;
        bJigid = false;
        bDeveloperEdition = false;
        bStandardEdition = false;
    }
}

