/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailService
extends ServiceBase {
    private static final String KEYPASSWORD = "keypassword";
    private static final String KEYSTOREPASSWORD = "keystorepassword";
    private static final String PASSWORD = "password";
    private static final String OLDSEEDVALFORSM = "0yJ!@1$r8p0L@r1$6yJ!@1rj";
    private String emailSpoolDir = null;
    private String emailUndeliverDir = null;
    private String mailServer = null;
    private String username = "";
    private String password = "";
    private int mailPort = -1;
    private int mailTimeout = -1;
    private Boolean useTLS = Boolean.FALSE;
    private Boolean useSSL = Boolean.FALSE;
    private boolean bMailSentLoggingEnable = true;
    private boolean bSpoolEnable = true;
    private File spoolDir = null;
    private File undeliverDir = null;
    private boolean bMaintainConnections = true;
    private int maxDeliveryThreads = 10;
    private boolean spoolToMemory = false;
    private int spoolMessagesLimit = 50000;
    private boolean allowDownload = true;
    private final String separator = ":  ";
    private final String rootDirPattern = "{neo.rootdir}";
    private final int rootDirLen = "{neo.rootdir}".length();
    private String severity = "warning";
    private long schedule_time = 0L;
    private ConfigMap settings;
    private boolean bFastMail = false;
    private boolean bypassSoftCache = false;
    private File configfile = null;
    private String rootdir = null;
    private boolean mailSpoolerStarted = false;
    private Boolean sign = Boolean.FALSE;
    private String keystore = "";
    private String keystorePassword = "";
    private String keyPassword = "";
    private String keyAlias = "";
    private String seed = null;
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);

    public MailService(File file, String rootdir) {
        this.configfile = file;
        this.rootdir = rootdir;
        this.setEnableWatch(true);
        this.setWatchFile(this.configfile);
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error("Error initializing Mail Service", (Throwable)e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.configfile);
            this.settings.init(this, "configuration");
            this.setSettings(this.settings);
            if (!this.mailSpoolerStarted) {
                this.doStartup();
            }
        }
        catch (Throwable ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.configfile);
        this.settings.setUnchanged();
    }

    public Map getSettings() {
        return this.settings;
    }

    public void setSettings(Map settings) {
        this.emailSpoolDir = (String)settings.get("spooldir");
        if (this.emailSpoolDir != null && this.emailSpoolDir.indexOf("{neo.rootdir}") != -1) {
            this.emailSpoolDir = this.rootdir + this.emailSpoolDir.substring(this.emailSpoolDir.indexOf("{neo.rootdir}") + this.rootDirLen);
        }
        this.emailUndeliverDir = (String)settings.get("undeliverdir");
        if (this.emailUndeliverDir != null && this.emailUndeliverDir.length() > this.rootDirLen && this.emailUndeliverDir.indexOf("{neo.rootdir}") >= 0 && this.emailUndeliverDir.indexOf("{neo.rootdir}") != -1) {
            this.emailUndeliverDir = this.rootdir + this.emailUndeliverDir.substring(this.emailUndeliverDir.indexOf("{neo.rootdir}") + this.rootDirLen);
        }
        this.setServer((String)settings.get("server"));
        this.setPort(((Number)settings.get("port")).intValue());
        this.setTimeout(((Number)settings.get("timeout")).intValue());
        this.setMailSentLoggingEnable((Boolean)settings.get("mailsentloggingenable"));
        this.setSeverity(settings.get("severity") != null ? (String)settings.get("severity") : "warning");
        this.setSchedule(((Number)settings.get("schedule")).intValue());
        Object val = settings.get("spoolenable");
        if (val != null) {
            this.bSpoolEnable = (Boolean)val;
            this.setSpoolEnable(this.bSpoolEnable);
        }
        if ((val = settings.get("allowdownload")) != null) {
            this.allowDownload = (Boolean)val;
        } else {
            settings.put("allowdownload", Boolean.TRUE);
        }
        this.setAllowDownload((Boolean)settings.get("allowdownload"));
        val = settings.get("usetls");
        if (val != null) {
            this.useTLS = (Boolean)val;
            this.setUseTLS(this.useTLS);
        }
        if ((val = settings.get("usessl")) != null) {
            this.useSSL = (Boolean)val;
            this.setUseSSL(this.useSSL);
        }
        if ((val = settings.get("username")) != null) {
            this.username = (String)val;
            this.setUsername(this.username);
        }
        if ((val = settings.get(PASSWORD)) != null) {
            this.password = (String)val;
        }
        if ((val = settings.get("sign")) != null) {
            this.sign = (Boolean)val;
            this.setSign(this.sign);
        }
        if ((val = settings.get("keystore")) != null) {
            this.keystore = (String)val;
            this.setKeystore(this.keystore);
        }
        if ((val = settings.get(KEYSTOREPASSWORD)) != null) {
            this.keystorePassword = (String)val;
        }
        if ((val = settings.get(KEYPASSWORD)) != null) {
            this.keyPassword = (String)val;
        }
        if ((val = settings.get("keyalias")) != null) {
            this.keyAlias = (String)val;
            this.setKeyAlias(this.keyAlias);
        }
        if (this.bFastMail) {
            val = settings.get("maintainconnections");
            if (val != null) {
                this.bMaintainConnections = (Boolean)val;
            }
            if ((val = settings.get("spooltomemory")) != null) {
                this.spoolToMemory = (Boolean)val;
            }
            if ((val = settings.get("maxthreads")) != null) {
                this.maxDeliveryThreads = ((Number)val).intValue();
            }
            if ((val = settings.get("spoolmessageslimit")) != null) {
                this.spoolMessagesLimit = ((Number)val).intValue();
            }
        } else {
            this.bMaintainConnections = false;
            this.spoolToMemory = false;
        }
    }

    private void doStartup() {
        this.spoolDir = new File(this.emailSpoolDir);
        if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && !this.spoolDir.exists()) {
            this.spoolDir.mkdirs();
        }
        this.undeliverDir = new File(this.emailUndeliverDir);
        if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && !this.undeliverDir.exists()) {
            this.undeliverDir.mkdirs();
        }
        this.mailSpoolerStarted = true;
    }

    public synchronized boolean isMailSentLoggingEnable() {
        return this.bMailSentLoggingEnable;
    }

    public synchronized void setMailSentLoggingEnable(boolean bEnable) {
        this.bMailSentLoggingEnable = bEnable;
        this.settings.put("mailsentloggingenable", bEnable ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized String getServer() {
        return this.mailServer;
    }

    public synchronized String getServerFromAdministrator() {
        return this.mailServer;
    }

    public synchronized void setServer(String server) {
        this.mailServer = server;
        this.settings.put("server", server);
    }

    public synchronized void setSeverity(String level) {
        this.severity = level;
        this.settings.put("severity", level);
    }

    public synchronized void deleteServer(String server) {
        String currentServer = (String)this.settings.get("server");
        if (currentServer != null && currentServer.equalsIgnoreCase(server)) {
            this.settings.put("server", "");
            this.settings.put("usetls", (Object)false);
            this.settings.put("usessl", (Object)false);
            this.settings.put("username", "");
            this.settings.put(PASSWORD, "");
            this.settings.put("sign", (Object)false);
            this.settings.put("keystore", "");
            this.settings.put(KEYSTOREPASSWORD, "");
            this.settings.put(KEYPASSWORD, "");
            this.settings.put("keyalias", "");
            this.resetSettings();
            this.settings.setChanged(this.settings, "server", "");
        }
    }

    private void resetSettings() {
        this.mailServer = null;
        this.username = "";
        this.password = "";
        this.useTLS = Boolean.FALSE;
        this.useSSL = Boolean.FALSE;
        this.sign = Boolean.FALSE;
        this.keystore = "";
        this.keystorePassword = "";
        this.keyPassword = "";
        this.keyAlias = "";
        this.allowDownload = true;
    }

    public String getSMPassword() {
        return PasswordUtils.reEncryptForSM(this.password, this.seed, OLDSEEDVALFORSM);
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    protected String getSeed() {
        return this.seed;
    }

    private String encryptPassword(String p) {
        return PasswordUtils.encryptPassword(p, this.seed);
    }

    private String decryptPassword(String password) {
        return PasswordUtils.decryptPassword(password, this.seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        if (oldSeed != null && oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        String oldPassword = this.getPassword();
        String newPassword = null;
        ConfigMap configMap = this.settings;
        synchronized (configMap) {
            try {
                if (oldPassword != null && oldPassword.length() > 0) {
                    this.password = newPassword = PasswordUtils.reEncryptWithNewSeed(oldPassword, oldSeed, this.seed);
                    this.settings.put(PASSWORD, newPassword);
                }
                if ((oldPassword = this.getKeystorePassword()) != null && oldPassword.length() > 0) {
                    this.keystorePassword = newPassword = PasswordUtils.reEncryptWithNewSeed(oldPassword, oldSeed, this.seed);
                    this.settings.put(KEYSTOREPASSWORD, newPassword);
                }
                if ((oldPassword = this.getKeyPassword()) != null && oldPassword.length() > 0) {
                    this.keyPassword = newPassword = PasswordUtils.reEncryptWithNewSeed(oldPassword, oldSeed, this.seed);
                    this.settings.put(KEYPASSWORD, newPassword);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setPassword(String password) {
        this.setPassword(password, PASSWORD);
    }

    public void setKeystorePassword(String keystorePassword) {
        this.setPassword(keystorePassword, KEYSTOREPASSWORD);
    }

    public void setKeyPassword(String keyPassword) {
        this.setPassword(keyPassword, KEYPASSWORD);
    }

    private void setPassword(String password, String type) {
        password = this.encryptPassword(password);
        if (type.equalsIgnoreCase(PASSWORD)) {
            this.password = password;
            this.settings.put(PASSWORD, password);
        } else if (type.equalsIgnoreCase(KEYSTOREPASSWORD)) {
            this.keystorePassword = password;
            this.settings.put(KEYSTOREPASSWORD, password);
        } else if (type.equalsIgnoreCase(KEYPASSWORD)) {
            this.keyPassword = password;
            this.settings.put(KEYPASSWORD, password);
        }
    }

    public void setUsername(String username) {
        this.username = username;
        this.settings.put("username", username);
    }

    public synchronized int getPort() {
        return this.mailPort;
    }

    public synchronized void setPort(int port) {
        this.mailPort = port;
        this.settings.put("port", new Integer(port));
    }

    public synchronized void setPort(double port) {
        this.mailPort = new Double(port).intValue();
        this.settings.put("port", new Integer(this.mailPort));
    }

    public synchronized int getTimeout() {
        return this.mailTimeout;
    }

    public synchronized void setTimeout(int timeout) {
        this.mailTimeout = timeout;
        this.settings.put("timeout", new Integer(timeout));
    }

    public synchronized void setTimeout(double timeout) {
        this.mailTimeout = new Double(timeout).intValue();
        this.settings.put("timeout", new Integer(this.mailTimeout));
    }

    public synchronized long getSchedule() {
        return this.schedule_time;
    }

    public synchronized void setSchedule(int sched) {
        if (sched <= 0) {
            sched = 1;
        }
        this.schedule_time = sched * 1000;
        this.settings.put("schedule", new Integer(sched));
    }

    public synchronized void setSchedule(double sched) {
        int s = new Double(sched).intValue();
        if (s <= 0) {
            s = 1;
        }
        this.schedule_time = s * 1000;
        this.settings.put("schedule", new Integer(s));
    }

    public synchronized boolean isSpoolEnable() {
        return this.bSpoolEnable;
    }

    public synchronized void setSpoolEnable(boolean bEnable) {
        this.bSpoolEnable = bEnable;
        this.settings.put("spoolenable", bEnable ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized boolean isAllowDownload() {
        return this.allowDownload;
    }

    public synchronized void setAllowDownload(boolean bEnable) {
        this.allowDownload = bEnable;
        this.settings.put("allowdownload", bEnable ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized boolean isMaintainConnections() {
        return this.bMaintainConnections;
    }

    public synchronized void setMaintainConnections(boolean bEnable) {
        if (this.bFastMail) {
            this.bMaintainConnections = bEnable;
            this.settings.put("maintainconnections", bEnable ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized int getMaxDeliveryThreads() {
        return this.maxDeliveryThreads;
    }

    public synchronized void setMaxDeliveryThreads(int count) {
        this.maxDeliveryThreads = count;
        this.settings.put("maxthreads", new Integer(count));
    }

    public synchronized void setMaxDeliveryThreads(double count) {
        this.maxDeliveryThreads = new Double(count).intValue();
        this.settings.put("maxthreads", new Integer(this.maxDeliveryThreads));
    }

    public synchronized boolean isSpoolToMemory() {
        return this.spoolToMemory;
    }

    public synchronized void setSpoolToMemory(boolean bEnable) {
        if (this.bFastMail) {
            this.spoolToMemory = bEnable;
            this.settings.put("spooltomemory", bEnable ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized int getSpoolMessagesLimit() {
        return this.spoolMessagesLimit;
    }

    public synchronized void setSpoolMessagesLimit(int count) {
        this.spoolMessagesLimit = count;
        this.settings.put("spoolmessageslimit", new Integer(count));
    }

    public synchronized void setSpoolMessagesLimit(double count) {
        this.spoolMessagesLimit = new Double(count).intValue();
        this.settings.put("spoolmessageslimit", new Integer(this.spoolMessagesLimit));
    }

    public void setUseTLS(boolean bEnable) {
        this.useTLS = bEnable;
        this.settings.put("usetls", this.useTLS);
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseSSL(boolean bEnable) {
        this.useSSL = bEnable;
        this.settings.put("usessl", this.useSSL);
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setBypassSoftCache(boolean bEnable) {
        this.bypassSoftCache = bEnable;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
        this.settings.put("sign", this.sign);
    }

    public boolean isSign() {
        return this.sign;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
        this.settings.put("keystore", keystore);
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        this.settings.put("keyalias", keyAlias);
    }

    protected URL resolveUrl(String url) {
        URL u;
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
            try {
                u = new URL(url);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (url.startsWith("java:comp/env/url")) {
            try {
                InitialContext ctx = new InitialContext();
                u = (URL)ctx.lookup(url);
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            u = new URL(url);
        }
        catch (Exception ex) {
            return null;
        }
        return u;
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("configuration.keys", "severity,logpath,spooldir,undeliverdir,path,server,port,timeout,schedule,mailsentloggingenable,spoolenable,maintainconnections,maxthreads,spooltomemory,spoolmessageslimit,usetls,usessl,username,password,sign,keystore,keystorepassword,keyalias,keypassword,allowdownload");
            this.rb.put("configuration.types", "java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Number,java.lang.Boolean,java.lang.Number,java.lang.Boolean,java.lang.Boolean,java.lang.String,java.lang.String,java.lang.Boolean,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.Boolean");
            this.rb.put("configuration.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter");
        }
        return this.rb;
    }

    public boolean storeModifiedMap(Map<String, Object> mailSettingMap) {
        this.settings.clear();
        this.settings.putAll(mailSettingMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing mail", (Throwable)e);
            return false;
        }
        return true;
    }
}

