/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.ApplicationException;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.SpConfiguration;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.util.RB;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class SamlService
extends ServiceBase {
    private File samlServiceFile;
    private String seed;
    private Map<String, IdpConfiguration> idpConfig;
    private Map<String, SpConfiguration> spConfig;
    public ConfigMap samlSettings;
    private String rootDir;
    private static final String IDP_LIST = "IdentityProvidersMap";
    private static final String SP_LIST = "ServiceProvidersMap";

    public SamlService(File serviceFile, String rootDir) {
        this.samlServiceFile = serviceFile;
        this.rootDir = rootDir;
        this.idpConfig = new ConfigMap();
        this.spConfig = new ConfigMap();
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading SamlService, ", e);
        }
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void addIdpMetadata(String alias, Object config1) {
        List<String> errors;
        IdpConfiguration config = (IdpConfiguration)config1;
        if (StringUtils.isEmpty((CharSequence)alias)) {
            throw new IdMetadataException(Messages.getString("SAML.AliasEmptyIDP"));
        }
        if (alias.length() > 50) {
            throw new IdMetadataException(Messages.getString("SAML.AliasTooLong"));
        }
        if (config.getMetadataRaw() != null) {
            config.setMetadataRaw(StringEscapeUtils.unescapeHtml4((String)config.getMetadataRaw()));
        }
        if ((errors = this.validateIdpSettings(config)).isEmpty()) {
            if (this.idpConfig.containsKey(alias)) {
                throw new IdpNameAlreadyExistsException(alias);
            }
        } else {
            throw new IdpException(errors);
        }
        this.idpConfig.put(alias, config);
        this.samlSettings.put(IDP_LIST, this.idpConfig);
        this.store();
    }

    public void modifyIdpMetadata(String oldAlias, String newAlias, Object config1) {
        IdpConfiguration config = (IdpConfiguration)config1;
        if (StringUtils.isEmpty((CharSequence)oldAlias) || StringUtils.isEmpty((CharSequence)newAlias)) {
            throw new IdMetadataException(RB.getString(this, "SAML.AliasEmptyIDP"));
        }
        List<String> errors = this.validateIdpSettings(config);
        if (errors.isEmpty()) {
            if (!this.idpConfig.containsKey(oldAlias)) {
                throw new IdpNotFoundException(oldAlias);
            }
        } else {
            throw new IdpException(errors);
        }
        this.idpConfig.remove(oldAlias);
        this.idpConfig.put(newAlias, config);
        this.samlSettings.put(IDP_LIST, this.idpConfig);
        this.store();
    }

    public void deleteIdpMetadata(String alias) {
        if (!this.idpConfig.containsKey(alias)) {
            throw new IdpNotFoundException(alias);
        }
        this.idpConfig.remove(alias);
        this.samlSettings.put(IDP_LIST, this.idpConfig);
        this.store();
    }

    public Map<String, Object> getAllIdpConfig() {
        LinkedHashMap<String, Object> sortedMap = new LinkedHashMap<String, Object>();
        this.idpConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put((String)x.getKey(), x.getValue()));
        return sortedMap;
    }

    public Map<String, Object> getAllSpConfig() {
        LinkedHashMap<String, Object> sortedMap = new LinkedHashMap<String, Object>();
        this.spConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put((String)x.getKey(), x.getValue()));
        return sortedMap;
    }

    public void addSpMetadata(String alias, Object config1) {
        SpConfiguration config = (SpConfiguration)config1;
        if (StringUtils.isEmpty((CharSequence)alias)) {
            throw new SpMetadataException(Messages.getString("SAML.AliasEmptySP"));
        }
        if (alias.length() > 50) {
            throw new SpMetadataException(Messages.getString("SAML.AliasTooLong"));
        }
        if (this.entityIdExists(config.getEntityId())) {
            throw new SpMetadataException(Messages.getString("SAML.DuplicateEntityId"));
        }
        List<String> errors = SamlService.validateSpSettings(config);
        if (errors.isEmpty()) {
            if (this.spConfig.containsKey(alias)) {
                throw new SpNameAlreadyExistsException(alias);
            }
        } else {
            throw new SpException(errors);
        }
        this.spConfig.put(alias, config);
        this.samlSettings.put(SP_LIST, this.spConfig);
        this.store();
    }

    public void modifySpMetadata(String oldAlias, String newAlias, Object newConfig1) throws CloneNotSupportedException {
        SpConfiguration newConfig = (SpConfiguration)newConfig1;
        if (StringUtils.isEmpty((CharSequence)oldAlias) || StringUtils.isEmpty((CharSequence)newAlias)) {
            throw new SpMetadataException(RB.getString(this, "AliasEmptySP"));
        }
        List<String> errors = SamlService.validateSpSettings(newConfig);
        if (errors.isEmpty()) {
            if (!this.spConfig.containsKey(oldAlias)) {
                throw new SpNotFoundException(oldAlias);
            }
        } else {
            throw new SpException(errors);
        }
        SpConfiguration oldConfig = this.spConfig.get(oldAlias).clone();
        this.spConfig.remove(oldAlias);
        this.spConfig.put(newAlias, newConfig);
        this.samlSettings.put(SP_LIST, this.spConfig);
        this.store();
    }

    public void deleteSpMetadata(String alias) {
        if (!this.spConfig.containsKey(alias)) {
            throw new SpNotFoundException(alias);
        }
        SpConfiguration config = this.spConfig.get(alias);
        if (config.isGenerated()) {
            File file = new File(config.getSignKeystorePath());
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.spConfig.remove(alias);
        this.samlSettings.put(SP_LIST, this.spConfig);
        this.store();
    }

    @Override
    public void start() throws ServiceException {
        super.start();
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.samlSettings = (ConfigMap)this.deserialize(this.samlServiceFile);
            if (this.samlSettings == null) {
                this.samlSettings = new ConfigMap(this, "saml");
                this.idpConfig = new ConfigMap();
                this.spConfig = new ConfigMap();
                this.samlSettings.put(IDP_LIST, this.idpConfig);
                this.samlSettings.put(SP_LIST, this.spConfig);
            } else {
                Object idplist = this.samlSettings.get(IDP_LIST);
                ObjectMapper mapper = new ObjectMapper();
                if (idplist != null) {
                    TreeMap<String, IdpConfiguration> map = new TreeMap<String, IdpConfiguration>(String.CASE_INSENSITIVE_ORDER);
                    ((Map)idplist).forEach((idpName, idp) -> {
                        if (idp instanceof Map) {
                            map.put((String)idpName, (IdpConfiguration)mapper.convertValue((Object)((Map)idp), IdpConfiguration.class));
                        } else if (idp instanceof IdpConfiguration) {
                            map.put((String)idpName, (IdpConfiguration)idp);
                        }
                    });
                    this.idpConfig = map;
                } else {
                    this.samlSettings.put(IDP_LIST, this.idpConfig);
                }
                Object splist = this.samlSettings.get(SP_LIST);
                if (splist != null) {
                    ConfigMap map = new ConfigMap();
                    ((Map)splist).forEach((spName, sp) -> {
                        if (sp instanceof Map) {
                            map.put(spName, (SpConfiguration)mapper.convertValue(sp, SpConfiguration.class));
                        } else if (sp instanceof SpConfiguration) {
                            map.put(spName, (SpConfiguration)sp);
                        }
                    });
                    this.spConfig = map;
                } else {
                    this.samlSettings.put(SP_LIST, this.spConfig);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void store() {
        this.serialize(this.samlSettings, this.samlServiceFile);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("saml.keys", "IdentityProvidersMap,ServiceProvidersMap");
            this.rb.put("saml.types", "java.util.Map, java.util.Map");
            this.rb.put("saml.formats", "coldfusion.server.MapFormatter, coldfusion.server.MapFormatter");
            this.rb.put("saml.value", "");
        }
        return this.rb;
    }

    private boolean entityIdExists(String entityId) {
        boolean exists = false;
        for (SpConfiguration config : this.spConfig.values()) {
            if (!config.getEntityId().equals(entityId)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public static List<String> validateSpSettings(SpConfiguration config) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.getEntityId() == null) {
            errors.add("entity_id");
        }
        if (config.getAcsUrl() == null) {
            errors.add("acs_url");
        } else {
            try {
                new URL(config.getAcsUrl());
            }
            catch (MalformedURLException e) {
                throw new CFSetupException(Messages.getString("SAML.AcsUrlMalformed", config.getAcsUrl()));
            }
        }
        if (errors.size() > 0) {
            return errors;
        }
        return errors;
    }

    private List<String> validateIdpSettings(IdpConfiguration config) {
        ArrayList<String> errors = null;
        errors = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)config.getMetadataUrl()) && StringUtils.isEmpty((CharSequence)config.getMetadataFilePath()) && StringUtils.isEmpty((CharSequence)config.getMetadataRaw())) {
            String errorMsg;
            if (StringUtils.isEmpty((CharSequence)config.getEntityId())) {
                errorMsg = "idp_entityId_not_found";
                errors.add(errorMsg);
            }
            if (StringUtils.isEmpty((CharSequence)config.getSsoUrl())) {
                errorMsg = "idp_sso_url_invalid";
                errors.add(errorMsg);
            }
        }
        return errors;
    }

    public static class IdMetadataException
    extends ApplicationException {
        public String exceptionMessage = "";

        public IdMetadataException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }

    public class IdpNameAlreadyExistsException
    extends ApplicationException {
        public String alias = "";

        public IdpNameAlreadyExistsException(String alias) {
            this.alias = alias;
        }
    }

    public static class IdpException
    extends ApplicationException {
        public String fieldsMissing = "";

        public IdpException(List<String> errors) {
            ArrayList<String> fields = new ArrayList<String>();
            Iterator<String> iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error;
                switch (error = iterator.next()) {
                    case "idp_entityId_not_found": {
                        fields.add("Entity Id");
                        break;
                    }
                    case "idp_sso_url_invalid": {
                        fields.add("Single Sign On URL");
                        break;
                    }
                    case "idp_cert_or_fingerprint_not_found_and_required": {
                        fields.add("IDP Encryption Certificate");
                    }
                }
            }
            this.fieldsMissing = String.join((CharSequence)",", fields);
        }
    }

    public class IdpNotFoundException
    extends ApplicationException {
        public String alias;

        public IdpNotFoundException(String alias) {
            this.alias = alias;
        }
    }

    public static class SpMetadataException
    extends ApplicationException {
        public SpMetadataException(String exceptionMessage) {
            super(exceptionMessage);
        }
    }

    public class SpNameAlreadyExistsException
    extends ApplicationException {
        public String name = "";

        public SpNameAlreadyExistsException(String name) {
            this.name = name;
        }
    }

    public static class SpException
    extends ApplicationException {
        public SpException(List<String> errors) {
            super(Messages.getString("SAML.serviceProviderMissingField", SpException.getMissingFields(errors)));
        }

        private static String getMissingFields(List<String> errors) {
            ArrayList<String> fields = new ArrayList<String>();
            Iterator<String> iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error;
                switch (error = iterator.next()) {
                    case "entity_id": {
                        fields.add("Entity Id");
                        break;
                    }
                    case "acs_url": {
                        fields.add("Assertion Consumer Service URL");
                    }
                }
            }
            return String.join((CharSequence)",", fields);
        }
    }

    public class SpNotFoundException
    extends ApplicationException {
        public String alias;

        public SpNotFoundException(String alias) {
            this.alias = alias;
        }
    }

    public class GenerateMetadataException
    extends ApplicationException {
        public String fieldsMissing = "";

        public GenerateMetadataException(List<String> errors) {
            ArrayList<String> fields = new ArrayList<String>();
            Iterator<String> iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error;
                switch (error = iterator.next()) {
                    case "entity_id": {
                        fields.add("Entity Id");
                        break;
                    }
                    case "acs_url": {
                        fields.add("Assertion Consumer Service URL");
                    }
                }
            }
            this.fieldsMissing = String.join((CharSequence)",", fields);
        }
    }

    public static class IdpMetadataException
    extends ApplicationException {
        public String exceptionMessage = "";

        public IdpMetadataException(String exceptionMessage) {
            super(exceptionMessage);
            this.exceptionMessage = exceptionMessage;
        }
    }
}

