/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.MailService;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchService
extends ServiceBase {
    private File configFile = null;
    private ConfigMap settings;
    private long interval = 120L;
    private boolean watchEnabled = false;
    private String watchExtensions = null;
    private static final Logger logger = LoggerFactory.getLogger(MailService.class);

    public WatchService(File wconfig) {
        this.configFile = wconfig;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading WatchSettings, ", e);
        }
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        this.settings.setConfigMapListener(this);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.configFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.configFile);
    }

    public void setSettings(Map settings) throws ServiceException {
        this.serialize(settings, this.configFile);
        this.load();
    }

    public Map getSettings() {
        return this.settings;
    }

    public long getInterval() {
        Object interval = this.settings.get("watch.interval");
        if (interval != null && interval instanceof Number) {
            this.interval = ((Number)interval).longValue();
        }
        return this.interval;
    }

    public void setInterval(long pollInterval) {
        this.interval = pollInterval;
        this.settings.put("watch.interval", new Long(pollInterval));
    }

    public String getWatchExtensions() {
        if (this.settings.get("watch.extensions") != null) {
            this.watchExtensions = this.settings.get("watch.extensions").toString();
        }
        return this.watchExtensions;
    }

    public void setWatchExtensions(String watchExtensions) {
        this.watchExtensions = watchExtensions;
        this.settings.put("watch.watchExtensions", watchExtensions);
    }

    public boolean isWatchEnabled() {
        Object enabled = this.settings.get("watch.watchEnabled");
        if (enabled != null) {
            this.watchEnabled = Boolean.valueOf(enabled.toString());
        }
        return this.watchEnabled;
    }

    public void setWatchEnable(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
        this.settings.put("watch.watchEnabled", (Object)watchEnabled);
    }

    @Override
    public boolean isInterested(File modifiedFile) {
        return modifiedFile.getName().equalsIgnoreCase(this.configFile.getName());
    }

    public boolean storeModifiedMap(Map<String, Object> watchMap) {
        this.settings.clear();
        this.settings.putAll(watchMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing mail", (Throwable)e);
            return false;
        }
        return true;
    }
}

