/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RangeValidation
extends ValidationDetails {
    private static final Logger logger = LoggerFactory.getLogger(RangeValidation.class);
    private String validationCriteria;
    private String from = "NA";
    private String to = "NA";
    private boolean fromInclusive = true;
    private boolean toInclusive = false;

    public String getValidationCriteria() {
        return this.validationCriteria;
    }

    public void setValidationCriteria(String validationCriteria) {
        this.validationCriteria = validationCriteria;
    }

    @Override
    public boolean validate(Object value) {
        try {
            String[] arr;
            Double dValue = Double.valueOf(String.valueOf(value));
            String rangeInput = String.valueOf(this.validationCriteria).trim();
            if (rangeInput.startsWith("(")) {
                this.fromInclusive = false;
            }
            if (rangeInput.endsWith("]")) {
                this.toInclusive = true;
            }
            if ((arr = (rangeInput = rangeInput.replace("(", "").replace(")", "").replace("[", "").replace("]", "")).split("-")).length != 2) {
                logger.error("incorrect range: {}", (Object)rangeInput);
                return false;
            }
            this.from = arr[0].trim();
            this.to = arr[1].trim();
            double fromD = arr[0].trim().equals("*") ? Double.MIN_VALUE : Double.valueOf(arr[0]);
            double toD = arr[1].trim().equals("*") ? Double.MAX_VALUE : Double.valueOf(arr[1]);
            return fromD <= dValue && toD >= dValue;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
    }

    @Override
    public String getErrorMessage() {
        if (StringUtils.isBlank((CharSequence)this.errorMessage)) {
            if (this.from.equals("*") && !this.to.equals("*")) {
                return this.toInclusive ? "value should be less than or equal to " + this.to + "." : "value should be less than to " + this.to + ".";
            }
            if (!this.from.equals("*") && this.to.equals("*")) {
                return this.fromInclusive ? "value should be greater than or equal to " + this.from + "." : "value should be greater than to " + this.from + ".";
            }
            if (!this.from.equals("*")) {
                String err = this.fromInclusive ? "value should be greater than or equal to " + this.from : "value should be greater than to " + this.from;
                err = err + " AND ";
                err = this.toInclusive ? err + "value should be less than or equal to " + this.to + "." : err + "value should be less than to " + this.to + ".";
                return err;
            }
        }
        return this.errorMessage;
    }
}

